unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, VInfo, AboutBox, Buttons, ToolWin, ComCtrls,registry;

const stringja = 'Ja, tu es!';
      stringnein = 'Nein, tu es nicht!';

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    askme1: TButton;
    auswahl: TLabel;
    GroupBox2: TGroupBox;
    Splitter1: TSplitter;
    askme2: TButton;
    janein: TLabel;
    ToolBar1: TToolBar;
    SpeedButton1: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton5: TSpeedButton;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    SpeedButton8: TSpeedButton;
    aboutbox: TPJAboutBoxDlg;
    procedure askme2Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure askme1Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private

    { Private-Deklarationen }
  public
    liste : Tstringlist;
    datei : string;
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

uses liste;

{$R *.DFM}

procedure TForm1.askme2Click(Sender: TObject);

var erg : integer;

begin
  erg :=  random(2);
  if erg = 1 then
    janein.caption := stringja
  else
    janein.caption := stringnein;
  askme2.enabled := false;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);

begin
  application.terminate;
end;



procedure TForm1.FormCreate(Sender: TObject);

const key1 = '.ask';
      key2 = 'Ask Me!';
      key3 = 'Ask Me!\shell\open';
      key4 = 'Ask Me!\shell\open\command';
      key7 = 'Ask Me!\defaulticon';

var reg : Tregistry;

begin
  randomize;
  liste := Tstringlist.create;
  reg := Tregistry.Create;
  try
    reg.rootkey := HKEY_CLASSES_ROOT;
    reg.openkey(key1,true);
    reg.writestring('',key2);
    reg.closekey;
    reg.openkey(key3,true);
    reg.writestring('','');
    reg.closekey;
    reg.openkey(key4,true);
    reg.writestring('','"'+Application.ExeName+ '" "%1"');
    reg.closekey;
    reg.openkey(key7,true);
    reg.WriteString('','"'+Application.ExeName+'"');
    reg.closekey;
  except
    showmessage('Dateityp Registrierung Fehlgeschlagen!');
  end;
  reg.free;
end;

procedure TForm1.FormDestroy(Sender: TObject);

begin
  liste.free;
end;

procedure TForm1.askme1Click(Sender: TObject);

var erg : integer;

begin
  erg := random(liste.count);
  auswahl.caption := liste.strings[erg];
  askme1.enabled := false;
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);

begin
  aboutbox.execute;
end;


procedure TForm1.SpeedButton4Click(Sender: TObject);

begin
  form2.visible := true;
  enabled := false;
end;

procedure TForm1.SpeedButton5Click(Sender: TObject);

begin
  form2.listbox.items.insert(0,form2.frage.text);
  form2.listbox.items.savetofile(datei);
  form2.listbox.items.delete(0);
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);

var i : integer;

begin
  if opendialog.execute = true then
  begin
    liste.clear;
    datei := opendialog.filename;
    liste.loadfromfile(datei);
    form2.frage.text := liste.strings[0];
    groupbox1.Caption := liste.strings[0];
    liste.delete(0);
    form2.listbox.items.loadfromfile(datei);
    form2.listbox.items.delete(0);
    for i := 0 to form2.listbox.items.count-1 do
    begin
      form2.listbox.checked[i] := true;
    end;
    speedbutton5.enabled := true;
    speedbutton4.enabled := true;
    askme1.enabled := true;
  end;
end;

procedure TForm1.SpeedButton6Click(Sender: TObject);

begin
  if savedialog.execute = true then
  begin
    liste.free;
    datei := savedialog.filename;
    form2.frage.Text := 'Was soll ich machen?';
    form2.listbox.items.add('Schlafen!');
    form2.listbox.checked[0] := true;
    form2.listbox.items.add('Essen!');
    form2.listbox.checked[1] := true;
    form2.listbox.items.add('Lessen!');
    form2.listbox.checked[2] := true;
    liste.add('Schlafen!');
    liste.add('Essen!');
    liste.add('Lessen!');
    speedbutton5.enabled := true;
    speedbutton4.enabled := true;
    askme1.enabled := true;
    SpeedButton4Click(sender);
  end;
end;

procedure TForm1.FormShow(Sender: TObject);

var i : integer;

begin
  if Paramcount >= 1 then        //Parameter vorhanden?
  begin
    datei := paramstr(1);
    liste.clear;
    liste.loadfromfile(datei);
    form2.frage.text := liste.strings[0];
    groupbox1.Caption := liste.strings[0];
    liste.delete(0);
    form2.listbox.items.loadfromfile(datei);
    form2.listbox.items.delete(0);
    for i := 0 to form2.listbox.items.count-1 do
    begin
      form2.listbox.checked[i] := true;
    end;
    speedbutton5.enabled := true;
    speedbutton4.enabled := true;
    askme1.enabled := true;
  end;
end;

end.
