; A/D Wandler Modul
; auslessen eines a/d wandler kanals und berechne des mittelwerts
; ber eine reihe von werten
; anzeige des Mittelwert sowie des letzen gemessen
; kein eigener timer
; sichert auerdem den aktuellen ad wandler wert in der variable
; AD_Value wobei diese mindestn 1 enthlt

; bentigt 3 byte speicher + buffer lnge in bytes (im iseg)

$NOMOD51
$INCLUDE(REG517A.INC)

; Einstellungen, konstanten
AD_Line EQU 1		; ausgabe zeile
AD_Row  EQU 1		; ausgabe spalte
Buffer_Length EQU 50 ; gre des puffers ber die mittewlwert gesichert werden soll 
;Kanal der vom a/d genutz werden soll
AD_Channel EQU 08h	

; Labels nach aussen bekannt
Public 	UP_INIT_AD, UP_GET_AD, AD_Value

DSEG at 38h
Buf_Pointer: DS 1 ; Pointer auf nchste schreibzelle
Counter: DS 1	; zhler fr 0,5 sek zur neuberechnung
AD_Value: DS 1	; letzter wert des A/D Wandlers fr weiter verarbeitung

ISEG at 0A0h
Buffer: DS	Buffer_Length


CSEG at 8200h


; funktion, Initialisiert das a/d modul
; ndert r0, a, psw
; sichert nix
UP_INIT_AD:
	
	mov Buf_Pointer, #Buffer ; erstes zu schreibedes feld
	mov Counter, #Buffer_Length	; erste mittelwert berechnung erst nach dem puffer einmal voll ist
	mov AD_Value, #1 ; definierter anfangs wert

	mov r1, #Buffer_Length
	mov r0, #Buffer
UP_INIT_AD_M1:
	mov @r0, #00	; nullen berschreiben zum init
	inc r0			; pointer 1 vorrcken	
	djnz r1, UP_INIT_AD_M1 ; schleife mit r1 als counter

	ret

;Methode, liet einen wert vom A/D Wandler (blockierend)
; speichert den wert im ringpuffer
; rechnet mittelwert aus nach dem ringpuffer einmal voll und dann alle 10 neuen werte
; gibt den mittelwert auf lcd aus
; ndert a, r0, r1, psw, r2, keine sicherung
; stacktiefe : 12
UP_GET_AD:
	mov a, #40h	; bios call a/d wandler wert lesen
	mov r0, #AD_Channel ; kanal angabe
	lcall 1000h 
	; rckgabe ist in r0 und r1, wir nehmen aber nur r0

	mov r1, Buf_Pointer ; zelle holen wo nchster wert reinkommt
	mov a, r0
	mov @r1, a	; wert speichern  
	mov r2, a	; zwischenspecihern

	;ausgabe des aktuellen wertes
	mov a, #02h ; BIOS Call Cursor Pos
	mov r0, #(AD_Row + 4)	; spalte
	mov r1, #AD_Line	; zeile
	lcall 1000h
	
	mov a, r2	; argument
	mov r0, a
	mov a, #15h ; bios call dezimal 8 bit ausgabe	
	lcall 1000h	; ausgabe!

	; wert des ad wandlers sichern fr variable zeit
	; basis des lauftextes, dabei wird aber dafr gesorgt
	; das der wert nie 0 ist!
	mov a, r2
	jnz UP_GET_AD_M2
	mov AD_Value, #1
	sjmp UP_GET_AD_M3
UP_GET_AD_M2:
	mov AD_Value, r2
UP_GET_AD_M3:		
	
	
	; Wert in Buffer schreiben
	inc Buf_Pointer ; Pointer hochzhlen
	;test ob pointer ber lnge hinaus ist
	mov a, Buf_Pointer
	cjne a, #(Buffer + Buffer_Length + 1), UP_GET_AD_M1
	mov Buf_Pointer, #Buffer ; auf 0 wieder starten wenn zuweit war	

UP_GET_AD_M1:
	; zhler wann mittelwert neugerechnet werden mu
	djnz Counter, UP_GET_AD_END	  
	mov Counter, #10 ; alle 10 werte neuen mittelwert berechnen

	;zuerst summe bilden
	; init fr summe
	mov r0, #Buffer	 ; beim 0ten element anfang
	mov r1, #Buffer_Length		; schleifen durchlauf so oft wieviele elemten im puffer
	mov a, #00	; low teil der summe
	mov r2, #00 ; high teil der summe
	
	; Rechnen!
UP_GET_AD_SUM:
	add a, @r0	   ; low teil wert aufaddiren, wenn berlauf wird cy gesetzt
	jnc UP_GET_AD_NOCY ; wenn cy gesetzt dann men wir high teil 1 aufaddiren:
	inc r2

UP_GET_AD_NOCY:	
	inc r0			; auf nchste element vorrcken
	djnz r1, UP_GET_AD_SUM 

	; danach mittelwert, dazu nutzen wir die muli/div unit
	; 16bit / 16 bit operation:
	mov MD0, a 	; dividend
	mov MD1, r2
	mov MD4, #Buffer_Length ; divisor
	mov MD5, #00
	; jetzt braucht er 4 zyklen, knnen ja schonmal cursor positionieren

	mov a, #02h ; BIOS Call Cursor Pos
	mov r0, #AD_Row	; spalte
	mov r1, #AD_Line	; zeile
	lcall 1000h

	; er sollte jetzt fertig sein, also ausgabe eine dezimal zahl
	; nur der Low teil des ergebniss sollte was haben
	; aufgrund unses divisors
	mov a, #15h ; bios call dezimal 8 bit ausgabe
	mov r0, MD0
	lcall 1000h	; ausgabe!

	mov a, MD1	; restliche werte auslesen um die div/multi unit glcklich zu machen
	mov a, MD4
	mov a, MD5

UP_GET_AD_END:
	ret


END