; ~~Hauptprogramm~~
; Beinhaltet Vordergrund Rountine (isr vom timer 1)
; und Hintergrund routine  
; sowie das Rechtecksignal zur simnulierung der rechenlast ber timer 0

; isr setzt aufgrund der zeit verschiedene flags die im
; hintergrund abgefragt werden um anschlieen funktionen
; der module aufzurufen

; Module haben absoulte addressen, men bei nderung
; angepasst werden
; nicht gerade schn aber dafr etwas strukturiert
; realokatible segmente geht leider net so recht (problem mit dem im system erlaubten bereich erst ab 8000h)

; ~~Resourcen Plan (Gesamt)~~
; Maximale Stacktiefe drfte 12 sein bei aufruf von	UP_ROTATE_TEXT

; Data bis 1fh fr bnke belegt
; bis 2fh belegt fr eventuell ntige bit-werte
; ab 30h beginnen daten zellen:
; 2 bytes fr zhler in timer 1
; 2 bytes fr variablen lauftexttimer
; ab 34h:
; 3 bytes fr uhrzeit
; ab 37h:
; 1 byte fr Lauftext Pointer
; ab 38h:
; 1 byte fr Mittelwert Pointer
; 1 byte fr Mittelwert Bercechnungs Timer
; 1 byte fr aktuellen mittelwert im bereich 1-255

; Stack liegt im IData bereich ab 7fh
; maximal stacktiefe bisher 12 
; etwas grozgig platz bis A0h

; ab A0h im IDATA: 
; 50 byte fr mittelwert berechnungs puffer

$NOMOD51
$INCLUDE(REG517A.INC)

; uhr Modul Importe
Extrn CODE (UP_INIT_CLOCK, UP_INC_CLOCK, UP_PRINT_CLOCK)

; text modul importe
Extrn CODE (UP_INIT_TEXT, UP_ROTATE_TEXT)

; ad modul importe
Extrn CODE (UP_INIT_AD, UP_GET_AD)
Extrn DATA (AD_VALUE)

BSEG at 0h
Clock_Flag: DBIT 1	; flag fr uhr sprung
AD_Flag: DBIT 1 ; flag fr a/d wandler ausfhrung
Text_Flag: DBIT 1; flag fr neue Lauftext durchlauf

DSEG at 30h
Count_L:	DS 1	; zhler fr 1 sek low
Count_H:	DS 1	; high
Count_F:	DS 1	; zhler fr variable zeitbasis abhnig vom a/d wert
Count_T:	DS 1	; zhler fr zeit  mit der text geschoben wird

ISEG at 80h
Stack:	 DS 20h	; stack bereich reserveren

; ~~~Einsprung Punkt fr Program~~~
CSEG at 8000h  ; Start Segement fr code
	mov SP, #(Stack - 1) ; stack pointer setzen
	sjmp start ; zum init gehen

; ~~~Timer 0 Interrupt~~~
ORG 800Bh
	cpl P3.2	; rechtecksignal erzeugen
	reti


; ~~~Timer 1 Interrupt~~~~
ORG 801Bh	 
	ljmp TIMER1_ISR
 
ORG 8030h 	
; Initialisierung 
start:
	mov a, #00h ; BIOS Call LCD init
	lcall 1000h 

	mov a, #03h ; BIOS Call Cursor umschalten
	mov r0, #0 	; Cursor aus
	lcall 1000h
	
	lcall UP_INIT_CLOCK	; Clock Init
	lcall UP_PRINT_CLOCK ; erste ausgabe + erste sekunde

	lcall UP_INIT_TEXT ; text init
	lcall UP_ROTATE_TEXT ; erste Ausgabe

	lcall UP_INIT_AD ; a/d wandler init

	; Timer 1 init, fr bentigte Zeittakte
	setb EAL	 ; Enable all interupts
	setb ET1	 ; Enable Timer   	

	clr TF1 ; anforderung lschen (sicherheitshalber)
	clr TR1	; timer anhalten (sicherheitshalber)

	mov TH1, #6  ;reload laden

	mov TL1, #6   ;anfangswert fr low teil
	orl TMOD, #0010$0000b ;timer 1 auf modus 1 stellen
	anl IP1, #1111$0111b  ;timer 1 auf untere priorittsebene schalten 

	; zhler fr timer 1 isr
	mov Count_L, #200	; zhler 1
	mov Count_H, #20 ; zhler 2
	mov Count_F, #255 ; fangen bei 256 an als a/d wert
	mov Count_T, #16 ; text_flag zhler

	; timer 0 init fr rechteck signal
	setb ET0		; intterupt erlauben

	clr TF0		; nur mal lschen und anhalten zur sicherheit (sollte nach start eigentlich eh net an sein)
	clr TR0

	mov TH0, P1	; Reload wert hngt vom eingestellten wert am DIP ab
	mov TL0, P1 ; erste runde

	orl TMOD, #0000$0010b	; auf modus 1, 8-bit autorelaod stellen	
	
	clr Clock_Flag
	clr AD_Flag

	setb TR0	    ; timer 0 starten
	setb TR1	   ; timer 1 starten	 
  	
; MainLoop - Hintergrundschleife
loop:
		
	jnb Clock_Flag, no_clock_update	; mu uhr upgedadet werden?
	clr Clock_Flag	; Anforderung lschen
	
	lcall UP_INC_CLOCK 	; zeit berechnen
	lcall UP_PRINT_CLOCK ; drucken!	

no_clock_update:		
	jnb AD_Flag, no_ad_update  ; a/d update?
	clr AD_Flag
	lcall UP_GET_AD

no_ad_update:		
	jnb Text_Flag, no_text_update	; laufdate update?
	clr Text_Flag
   	lcall UP_ROTATE_TEXT ; lauftext!	

no_text_update:
	mov TH0, P1	; frequenz fr rechteck updaten

	sjmp loop	; endlos loop



;ISR fr Timer 1, hier werden einige Zeittatke erzeugt
;(Vordergrund Routine)
;weder acc noch psw werden berht kein sichern ntig
;Minimale Abarbeitung:	6 Zyklen
;Maximale Abarbeitung:	21 Zyklen
TIMER1_ISR:
	; kommt alle 250 s
	
	djnz Count_F, TIMER1_ISR_M1 ;zhler 1 fr lauftext
	mov Count_F, AD_Value	;zhler wert ist variable abhngig vom wert den der a/d ausliest aber mindest 1
	djnz Count_T, TIMER1_ISR_M1
	mov Count_T, #16 ; erzeugter variabler takt wird durch 16 geteilt um sinnvolle geschwindigkeite zu erhalten d.h. minimal 4 ms rotationszeit, maximal 256 x 4 ms = 1024 ms
	setb Text_Flag ; lauftext update anfordern

TIMER1_ISR_M1:
	; Timer fr a/d wandler	
	djnz Count_L, TIMER1_ISR_END
	mov Count_L, #200
	; kommt alle 50 ms (250s * 200)
	setb AD_Flag	; 50 ms um ad wandlung anstoen

	; aufbauend auf a/d timer der uhrzeit timer
	djnz Count_H, TIMER1_ISR_END	
	mov Count_H, #20
	; kommt alle 1 s (50ms * 20)
	
	setb Clock_Flag	;  1 sekunde vergangen, uhr mu nachgestellt werden
		
TIMER1_ISR_END:	
	
	reti		  ; Return


END