{
*****Contact*****
Bei weiteren Fragen bitte Email an mich.
If Somebody needs an english guide feel free to write me an email.
tobi@tobis-page.de
*******Info******
Fraktal Test
ein kleines Programm um etwas mit Fraktalen herum zu experimentieren
!!Achtung!! Gleitkommafehler nicht unwahrscheinlich

Autor Tobias Mark tobi@tobis-page.de
Version 1.0 - 29.10.2005
1.01 - 4.11.2005 - Zum aufziehen des Fenster ist nun ein Shift-Linksklick ntig
******************
}
unit fraktal_test;
{
*****Anleitung*****
Fraktale werden "live" berechnet, man sollte mit Wartezeiten Rechnen,
eine Laufende Berechnung kann abgebrochen werden (eventuell etwas verzgert)
man sollte keine perfekte und reibungslose Funktion erwarten da es sich hierbei
nur um ein Demo handelt das etwas erweitert wurde

1. Mgliche Fraktale : (berrechen durch Klicken auf Button)
Mandelbrot : z = z^x + c;
Julia : z = z^x + c;
Newton1 :  z = z - f(z)/f'(z)  f(z) = z^4 - 1
Newton2 :  z = z - f(z)/f'(z)  f(z) = z^3 + j
Fraktal1, Fraktal : keine Formel Mainpuliertes Mandelbrot
Cosinus : z = cos(z^x + z^3 - z^2 + cos(c))
Sinus :  Z sin(z^x + z^3 - z^2 + cos(c))
Ln : z = Ln(z^x + z^3 - z^2 + cos(c))
Fraktal 3 :  z = z^exp + z + z^0.2 - c
- wobei x einstellbar ist ber "Exponent"

2. Gute Werte
ber die Buttons "Gute Werte" erreicht man die jeweils blichen
einstellen fr die Fraktale :
M - Mandelborot
N - Newton
J - Julia (wobei fr C aus einer Liste zufllig ausgewhlt wird)
C,S,Ln - Sinus Cosinus und Ln
1,2 - Fraktal 1 und 2
3 - Fraktal 3

3. Weitere Buttons:
+ - Verdoppelt den dargestellten Bereich (Zoom Out)
- - Halbiert den dargestellten Bereich (Zoom In)
Lschen - Setzt das Bild zurck (wichtig fr Mainpulations Optionen)
Laden - Ldt ein *.bmp Bild in den anzeige Bereich (wichtig fr Bild Manipulation )
Speichern - Speichert das aktuelle Bild als *.bmp

4. Einstellungen fr die Fraktale:
X,Y Max/Min - Gibt den Dargestellten Bereich der Komplexen Zahlebene an (fr alle
Fraktale)
Exponent - Dient zum verndern der Formel, verwendet bei Mandelbrot,Julia,Cosinus,Sinus,Ln
nur natrliche Zahlen empfohlen (aber kein mu)
Iterationen - Die Maximale Rekursions Tiefe, zu wenig fhrt zu ungenaune Bilder zu viel vergrert die
Rechenzeit massiv wert zwischen 50 und 500 whlen
Julia C - gibt den C - Paramater fr Julia an und wird auch in Fraktal 1 und 2 verwendet

Mit gedrckter Linker Maustaste kann ein Rahmen gezogen werden auf dem Bild um
neue X,Y Max/Min Koordinaten zu erhalten (Hinweis : Rahmen wird nicht angezeigt)
d.h. gewnschte Obere Ecke Klicken mit gedrckter Taste zur gewnschten Unteren Ecke fahren
und loslassen

Mit eine Klick der Rechte Maustaste im Bild kann ein Wert fr Julia C aufgenommen werden

5. Einstellungen fr die Darstellung:
Checkbox "Alternative Darstellung" - Bei einschalten wird Statt der Iterationstiefe
der letzte Wert von z als Ergebnis verwendet
Farb Modi - eine Ganzahliger Wert mit dem das Ergebnis multipliziert wird um es als
Farbe dazustellen
Bildmanipulation Auswahl
- Keine  - Verwendung von Farb Modi, berschreiben des Bildes
- Multiplikation - Multipliziert das Ergebnis mit dem aktuellen Farbwert des entsprechenden
Pixel (z.b. wenn vorher Bild geladen)       (Farbwert*Ergebnis)
- Division   gleich nur Farbwert /Ergenbis
- Addition   gleich nur Farbwert + Ergebnis
- Subtraktion gleich nur Farbwert - Ergebnis


******Hinweise zum Quellcode*****

Der Code entstand mehr als Quick'n'Dirty ich habe allerdings nachtrglich versucht
sinnvolle Name zu vergeben und ein paar Kommentare einzfgen;

Es wird die Unit JclComplex aus der JCL (Project Jedi) verwendet, ansonsten sollte
keine weiteren Komponenten ntig sein, Entwicklungs System war ein Windows XP und Delphi 7
Ein Teil der whrend der Programmierung aufgetreten Gleitkomma-Blcke wurde
durch einfache try except Blcke abgefangen die die Schleife mit Break einfach abbrechen
andere Eingangswerte fhren eventuell zu fehlern

Aufbau der Berechnungs Routinen:
Alle Fraktal Berechnug sind direkt hinter den Entsprechneden Button aufrufen
untergebracht das Prinzip ist immer gleich:

  setup;    //liet einstellung ein
  startcalc;    //ndert Programmstatus in "rechne"
  ***Intilaisierungen vornehmen***;

  for col :=0 to maxcol do  //Spalten schleife

    ***Werte Setzen***;

    application.ProcessMessages;  //Abbruch und Anti-Freez
    if cancel = true then    //ntig sonst geht Abbruch Button nicht

      ***Aufrumen bei Abbruch***
      stopcalc('abgebrochen');   //Programmstatus zurcksezten
      exit;


    for row := 0 to maxrow do  // Zeilen Schleife

      color := 1;  //Schleifen Zhle
      ***Werte Setzen***
      while (color >= max_iterations)
         ***Iterations Formel ***
         if *** Abbruch Bedinung *** then break;
         inc(color);

      if mode.Checked then  //Ergenbnis an Darstellungs Routine bergeben
        setpixel(col,row,round(z1.absoluteValueSqr))
      else
        setpixel(col,row,color);

  ****Normales aufrumen ***
  stopcalc('Info Text');   //Programmstatus zurksetzten

Zum ausprobieren einfach eine Routine kopieren und dann nach lust und laune
herumspielen
}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, JclComplex,math, ExtDlgs;

type
  TForm1 = class(TForm)
    ausgabe: TImage;
    mandel_calc: TButton;
    control_panel: TPanel;
    julia_calc: TButton;
    xmax_edit: TEdit;
    xmin_edit: TEdit;
    ymax_edit: TEdit;
    ymin_edit: TEdit;
    julia_re_edit: TEdit;
    julia_im_edit: TEdit;
    color_edit: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    fractal1_calc: TButton;
    save_button: TButton;
    fractal2_calc: TButton;
    fractal1_2_settings: TButton;
    label_x: TLabel;
    label_y: TLabel;
    mandel_settings: TButton;
    zoom_out: TButton;
    zoom_in: TButton;
    julia_settings: TButton;
    newton2_calc: TButton;
    newton1_calc: TButton;
    newton_settings: TButton;
    exp_edit: TEdit;
    Label7: TLabel;
    options: TRadioGroup;
    save: TSaveDialog;
    open: TOpenPictureDialog;
    open_button: TButton;
    cosinus_calc: TButton;
    c_s_ln_settings: TButton;
    sinus_calc: TButton;
    ln_calc: TButton;
    fractal3_calc: TButton;
    fractal3_settings: TButton;
    Label8: TLabel;
    Label9: TLabel;
    clear_output: TButton;
    mode: TCheckBox;
    iter_edit: TEdit;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    cancel_button: TButton;
    procedure mandel_calcClick(Sender: TObject);
    procedure julia_calcClick(Sender: TObject);
    procedure fractal1_calcClick(Sender: TObject);
    procedure save_buttonClick(Sender: TObject);
    procedure fractal2_calcClick(Sender: TObject);
    procedure fractal1_2_settingsClick(Sender: TObject);
    procedure ausgabeMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure mandel_settingsClick(Sender: TObject);
    procedure zoom_outClick(Sender: TObject);
    procedure zoom_inClick(Sender: TObject);
    procedure julia_settingsClick(Sender: TObject);
    procedure newton2_calcClick(Sender: TObject);
    procedure newton1_calcClick(Sender: TObject);
    procedure newton_settingsClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure open_buttonClick(Sender: TObject);
    procedure c_s_ln_settingsClick(Sender: TObject);
    procedure cosinus_calcClick(Sender: TObject);
    procedure sinus_calcClick(Sender: TObject);
    procedure ln_calcClick(Sender: TObject);
    procedure fractal3_calcClick(Sender: TObject);
    procedure fractal3_settingsClick(Sender: TObject);
    procedure clear_outputClick(Sender: TObject);
    procedure modeClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ausgabeMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X_cord, Y_cord: Integer);
    procedure ausgabeMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X_cord, Y_cord: Integer);
    procedure cancel_buttonClick(Sender: TObject);
  private
    //Gre eines Pixel in der Komplexen ebene
    deltaP,deltaQ : extended;
    //exponent fr speziele Fraktale
    exp : extended;
    //Koordinaten "Ecken"
    xmax,xmin,ymin,ymax : extended;
     //Gre des Fenster, eingabe fr Farbmodifikator
    maxrow,maxcol,colormodi : integer;
    //Maximale Ilterations Tiefe
    max_iterations : integer;
    // Wird gerade zoom fenster gezogen?
    getrect : boolean;
    // Berechnung abbrechen?
    cancel : boolean;

    //macht die vorbereitung fr berechnung
    procedure setup;
    //malt einen punkt in abhngigkeit von options
    procedure setpixel(x,y,color : integer);
    //deaktviert panel
    procedure startcalc;
    //aktiviert panel
    procedure stopcalc(fractal : string);
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

const prog_name = 'Fraktal Test 1.0';

implementation

{$R *.dfm}

//************ Hilfsfunktionen zum Berechnungs Ablauf *************

//Initialisiert die Variablen vor der Berechnung
procedure Tform1.setup;

begin
  xmax := strtofloat(xmax_edit.Text);
  xmin := strtofloat(xmin_edit.Text);
  ymax := strtofloat(ymax_edit.Text);
  ymin := strtofloat(ymin_edit.Text);
  colormodi := strtoint(color_edit.Text);
  maxcol := ausgabe.Width;
  maxrow := ausgabe.height;
  deltaP := (xmax - xmin) / maxcol;
  deltaQ := (ymax - ymin) / maxrow;
  max_iterations := strtoint(iter_edit.Text);
  exp := strtofloat(exp_edit.Text);
end;

//Aufrufen zu Beginn der Berechnung Deaktiviert Eingabe mglichkeiten
procedure Tform1.startcalc;

begin
  control_panel.Enabled := false;
  cancel_button.Visible := true;
  form1.Caption := prog_name + ' ***  Rechne *** Bitte Warten';
end;

//Aktiviert eingabe Mglichkeiten wieder
procedure Tform1.stopcalc(fractal : string);

begin
  control_panel.Enabled := true;
  cancel_button.Visible := false;
  cancel := false;
  form1.Caption := prog_name + ' ' + fractal;
end;

//Malt einen Bildpunkt in abhnigkeit vom Manipulations Modus
procedure Tform1.setpixel(x,y,color : integer);

begin
  case options.ItemIndex of
    0 : ausgabe.Canvas.Pixels[x,y] := color*colormodi;
    1 : ausgabe.Canvas.Pixels[x,y] := ausgabe.Canvas.Pixels[x,y] * color;
    2 : ausgabe.Canvas.Pixels[x,y] := round(ausgabe.Canvas.Pixels[x,y] / color);
    3 : ausgabe.Canvas.Pixels[x,y] := ausgabe.Canvas.Pixels[x,y] + color;
    4 : ausgabe.Canvas.Pixels[x,y] := ausgabe.Canvas.Pixels[x,y] - color;
  end;
end;

//******************* Fraktale Berechnen ***********************

//Mandelbrot Berechnen
procedure TForm1.mandel_calcClick(Sender: TObject);

var p,q : extended;   //Laufvariable fr Koordinaten
    color,row,col : integer; //zhler
    z1,z2 :  TJclComplex;  //unsere Zahlen zum rechnen

begin
  setup;
  startcalc;
  P := xmin;
  z1 := TJclComplex.create;
  z2 := TJclComplex.Create;
  for col :=0 to maxcol do
  begin
    Q := Ymax;
    application.ProcessMessages;
    if cancel = true then
    begin  //cancel
      z1.Free;
      z2.Free;
      stopcalc('abgebrochen');
      exit;
    end;
    for row := 0 to maxrow do
    begin
      z1.Assign(0,0);
      color := 1;
      Q := Q - deltaQ;
      z2.Assign(p,q);
      repeat
        z1.CRealPwr(exp);
        z1.CAdd(z2);
        inc(color);
      until (color >= max_iterations) or (sqr(z1.RealPart)+sqr(z1.ImaginaryPart) >= 4);
      if mode.Checked then
      setpixel(col,row,round(z1.absoluteValueSqr))
      else
      setpixel(col,row,color);
    end;
    P := P + deltaP;
  end;
  z1.Free;
  z2.Free;
  stopcalc('Mandelbrot');
end;

//Julia Berechnen
procedure TForm1.julia_calcClick(Sender: TObject);


var x,y : extended;
    color,row,col : integer;
    z1,z2 :  TJclComplex;

begin
  setup;
  startcalc;
  z1 := TJclComplex.create;
  z2 := TJclComplex.Create;
  z2.Assign(strtofloat(julia_re_edit.Text),strtofloat(julia_im_edit.Text)); //c
  for col :=0 to maxcol do
  begin
    application.ProcessMessages;
    if cancel = true then
    begin  //cancel
      z1.Free;
      z2.Free;
      stopcalc('abgebrochen');
      exit;
    end;
    for row := 0 to maxrow do
    begin
      x := xmin + col * deltaP;
      y := ymax - row * deltaQ;
      z1.Assign(x,y);
      color := 1;
      repeat
        z1.CRealPwr(exp);
        z1.CAdd(z2);
        inc(color);
      until (color >= max_iterations) or (sqr(z1.RealPart)+sqr(z1.ImaginaryPart) >= 5);
      if mode.Checked then
      setpixel(col,row,round(z1.absoluteValueSqr))
      else
      setpixel(col,row,color);
    end;
  end;
  z1.Free;
  z2.Free;
  stopcalc('Julia');
end;

//Fraktal 1 Berechnen
procedure TForm1.fractal1_calcClick(Sender: TObject);

var p,q,x,y : extended;
    color,row,col : integer;
    xsquare,ysquare : extended;
    p2,q2 : extended;

begin
  setup;
  startcalc;
  P := xmin;
  P2 := strtofloat(julia_re_edit.Text);
  Q2 := strtofloat(julia_im_edit.Text);
  for col :=0 to maxcol do
  begin
    Q := Ymax;
    application.ProcessMessages;
    if cancel = true then
    begin  //cancel
      stopcalc('abgebrochen');
      exit;
    end;
    for row := 0 to maxrow do
    begin
      x := 0.0;
      y := 0.0;
      color := 1;
      Q := Q - deltaQ;
      repeat
        //Diese Bleibt von Hand mit z berechnet wegen der seltsamen Ilterations Formel
        if color mod 2 = 0 then xsquare := q2 else xsquare := x*x;
        if color mod 2 = 0 then ysquare := y*y else ysquare := p2;
        y := 2*x*y + q +q2;
        x := xsquare - ysquare + p +p2;
        inc(color);
      until (color >= max_iterations) or (xsquare+ysquare >= 5);
      if mode.Checked then
      setpixel(col,row,round(sqr(x)+sqr(y)))
      else
      setpixel(col,row,color);
    end;
    P := P + deltaP;
  end;
  stopcalc('Fraktal 1');
end;

//Fraktal 2 Berechnen
procedure TForm1.fractal2_calcClick(Sender: TObject);

var p,q,x,y : extended;
    color,row,col : integer;
    xsquare,ysquare : extended;
    p2,q2 : extended;

begin
  setup;
  startcalc;
  P := xmin;
  P2 := strtofloat(julia_re_edit.Text);
  Q2 := strtofloat(julia_im_edit.Text);
  for col :=0 to maxcol do
  begin
    Q := Ymax;
    application.ProcessMessages;
    if cancel = true then
    begin  //cancel
      stopcalc('abgebrochen');
      exit;
    end;
    for row := 0 to maxrow do
    begin
      x := 0.0;
      y := 0.0;
      color := 1;
      Q := Q - deltaQ;
      repeat
        if color mod 2 = 0 then xsquare := q2 else xsquare := x*X;
        if color mod 2 = 0 then ysquare := y*Y else ysquare := p2;
        y := 4*x*y + q +q2;
        x := xsquare - ysquare + p +p2;
        inc(color);
      until (color >= max_iterations) or (xsquare+ysquare >= 5);
      if mode.Checked then
      setpixel(col,row,round(sqr(x)+sqr(y)))
      else
      setpixel(col,row,color);
    end;
    P := P + deltaP;
  end;
  stopcalc('Fraktal 2');
end;

//Newton mit f(x) = x^4-1; Berechnen
procedure TForm1.newton1_calcClick(Sender: TObject);

var color,col,row : integer;
    x,y: extended;
    nenner,x2 : extended;

begin
  setup;
  startcalc;
  for col :=0 to maxcol do
  begin
    application.ProcessMessages;
    if cancel = true then
    begin  //cancel
      stopcalc('abgeborchen');
      exit;
    end;
    for row := 0 to maxrow do
    begin
      x := Xmin+col*deltap;
      y := Ymax-row*deltaq;
      color := 0;
      while (color <= max_iterations) do
      begin

          {  So sieht das ganze mit JCL aus :
          z2.Assing(z1.RealPart,z1.ImaginaryPart);
          z2.CRealPwr(4);
          z2.CSub(1,0);
          z3.Assign(z1.RealPart,z1.ImaginaryPart);
          z3.CRealPwr(3);
          z3.CMul(4,0);
          try
            z2.CDiv(z3);
          except
            break;
            z2.CDiv(0.000001,0.0000001); //division durch 0?
          end;
          z1.CSub(z2);
        except
          break;
        end;
        }

        //aus c - programm: (schneller)
       // = folgender Zeile  ( (a^2+b^2)^3)
        nenner := (x * x + y * y) * (x * x + y * y) * (x * x + y * y);
        if nenner = 0 then nenner := 0.0000001;    // gegen division durch 0

      //Keine Ahnung wie das umgeformt wurde aber es stimmt! ;)
      x2 := 3.0/4.0 * x + x/4.0 * (x * x - 3.0 * y * y) / nenner;
      y := 3.0/4.0 * y - y/4.0 * (3.0 *  x * x - y * y) / nenner;
      x := x2;

      if  ( (power (x - 0, 2) + power (y - 1, 2)) < 0.01 ) or
          ( (power (x + 1, 2) + power (y - 0, 2)) < 0.01 ) or
          ( (power (x - 0, 2) + power (y + 1, 2)) < 0.01 ) or
          ( (power (x - 1, 2) + power (y - 0, 2)) < 0.01    )
        then
        break;
        inc(color);
      end;
      if mode.Checked then
      setpixel(col,row,round(sqr(x)+sqr(y)))
      else
      setpixel(col,row,color);
    end;
  end;
  stopcalc('Newton 1');
end;

//Newton mit f(x) = x^3 + j Berechnen
procedure TForm1.newton2_calcClick(Sender: TObject);

var x,y : extended;
    color,row,col : integer;
    z1,z2,z3 :  TJclComplex;
    xold,yold: extended;
    help : extended;

begin
  setup;
  startcalc;
  z1 := TJclComplex.create;
  z2 := TJclComplex.Create;
  z3 := TJclComplex.Create;
  help := sqrt(3) / 2;  //fr Nullstelle schon vorher rechnen
  for col :=0 to maxcol do
  begin
    application.ProcessMessages;
    if cancel = true then
    begin  //cancel
      z1.Free;
      z2.Free;
      z3.Free;
      stopcalc('abgeborchen');
      exit;
    end;
    for row := 0 to maxrow do
    begin
      x := xmin + col * deltaP;
      y := ymax - row * deltaQ;
      z1.Assign(x,y);
      color := 1;
      repeat
        try
          z2.Assign(z1.RealPart,z1.ImaginaryPart);
          z2.CRealPwr(3);
          z2.CAdd(0,1);
          z3.Assign(z1.RealPart,z1.ImaginaryPart);
          z3.CRealPwr(2);
          z3.CMul(3,0);
          try
            z2.CDiv(z3);
          except
            break;
            z2.CDiv(0.000001,0.0000001); //division durch 0?
          end;
          z1.CSub(z2);
        except
          break;
        end;
        xold := z1.RealPart;
        yold := z1.ImaginaryPart;
        try
          if  ( (power (xold - 0, 2) + power (yold - 1, 2)) < 0.01 )
          or  ( (power (xold - help, 2) + power (yold + 0.5, 2)) < 0.01 )
          or ( (power (xold + help, 2) + power (yold + 0.5, 2)) < 0.01 )
          then break;
        except
          break;
        end;
   { Abbruch  Erluterung :  wir schauen ob die additon des betrags des real und imaginr teils
     nahe 0 liegt, dabei ziehen wir jedoch die Nullstellen  entspcprechend ab
     (bei x^4-1  4 nullstellen : 0-j1; 1+j0; 0+j1; -1+j0;)
     => wir schauen ob unserer ergebniss nah einer Nullstelle liegt
     => fr ander funktionen mu die abbruch bedinungung an die nullstellen angepasst werden
    }
        inc(color);
      until (color >= max_iterations);
      if mode.Checked then
      setpixel(col,row,round(z1.absoluteValueSqr))
      else
      setpixel(col,row,color);
    end;
  end;
  z1.Free;
  z2.Free;
  z3.Free;
  stopcalc('Newton 2');
end;

//Cosinus cos(z^exp + z^3 - z^2 + cos(c)) Berechnen
procedure TForm1.cosinus_calcClick(Sender: TObject);

var p,q : extended;   //Zhler fr Koordinaten
    color,row,col : integer;
    z1,z2,z3,z4 :  TJclComplex;

begin
  setup;
  startcalc;
  P := xmin;
  z1 := TJclComplex.create;
  z2 := TJclComplex.Create;
  z3 := TJclComplex.Create;
  z4 := TJclComplex.Create;
  for col :=0 to maxcol do
  begin
    Q := Ymax;
    application.ProcessMessages;
    if cancel = true then
    begin  //cancel
      z1.Free;
      z2.Free;
      z3.Free;
      z4.Free;
      stopcalc('abgebrochen');
      exit;
    end;
    for row := 0 to maxrow do
    begin
      z1.Assign(0,0);
      color := 1;
      Q := Q - deltaQ;
      z2.Assign(p,q);
      repeat
        z3.Assign(z1.RealPart, z1.ImaginaryPart);
        z4.Assign(z1.RealPart, z1.ImaginaryPart);
        z1.CRealPwr(exp);
        z3.CRealPwr(3);
        z1.CAdd(z3);
        z4.CIntPwr(2);
        z1.CSub(z4);
        z2.CCos;
        z1.CAdd(z2);
        z1.CCos;
        inc(color);
      until (color >= max_iterations) or (sqr(z1.RealPart)+sqr(z1.ImaginaryPart) >= 5);
      if mode.Checked then
      setpixel(col,row,round(z1.absoluteValueSqr))
      else
      setpixel(col,row,color);
    end;
    P := P + deltaP;
  end;
  z1.Free;
  z2.Free;
  z3.Free;
  z4.Free;
  stopcalc('Cosinus');
end;

//Sinus z = sin(z^exp + z^3 - z^2 + cos(c))
procedure TForm1.sinus_calcClick(Sender: TObject);

var p,q : extended;
    color,row,col : integer;
    z1,z2,z3,z4 :  TJclComplex;

begin
  setup;
  startcalc;
  P := xmin;
  z1 := TJclComplex.create;
  z2 := TJclComplex.Create;
  z3 := TJclComplex.Create;
  z4 := TJclComplex.Create;
  for col :=0 to maxcol do
  begin
    Q := Ymax;
    application.ProcessMessages;
    if cancel = true then
    begin  //cancel
      z1.Free;
      z2.Free;
      z3.Free;
      z4.Free;
      stopcalc('abgebrochen');
      exit;
    end;
    for row := 0 to maxrow do
    begin
      z1.Assign(0,0);
      color := 1;
      Q := Q - deltaQ;
      z2.Assign(p,q);
      repeat
        z3.Assign(z1.RealPart, z1.ImaginaryPart);
        z4.Assign(z1.RealPart, z1.ImaginaryPart);

        z1.CRealPwr(exp);
        z3.CIntPwr(3);
        z1.CAdd(z3);
        z4.CIntPwr(2);
        z1.CSub(z4);
        z2.CCos;
        z1.CSub(z2);
        z1.CSin;

        if z1.RealPart > 1 then break;
        if z1.RealPart < -1 then break;
        if z1.ImaginaryPart > 1 then break;
        if z1.ImaginaryPart < -1 then break;

        inc(color);
      until (color >= max_iterations);
      setpixel(col,row,color);
    end;
    P := P + deltaP;
  end;
  z1.Free;
  z2.Free;
  z3.Free;
  z4.Free;
  stopcalc('Sinus');
end;

//Ln z = Ln(z^exp + z^3 - z^2 + cos(c))
procedure TForm1.ln_calcClick(Sender: TObject);

var p,q : extended;
    color,row,col : integer;
    z1,z2,z3,z4 :  TJclComplex;

begin
  setup;
  startcalc;
  P := xmin;
  z1 := TJclComplex.create;
  z2 := TJclComplex.Create;
  z3 := TJclComplex.Create;
  z4 := TJclComplex.Create;
  for col :=0 to maxcol do
  begin
    Q := Ymax;
    application.ProcessMessages;
    if cancel = true then
    begin  //cancel
      z1.Free;
      z2.Free;
      z3.Free;
      z4.Free;
      stopcalc('abgebrochen');
      exit;
    end;
    for row := 0 to maxrow do
    begin
      z1.Assign(0,0);
      color := 1;
      Q := Q - deltaQ;
      z2.Assign(p,q);
      repeat
        z3.Assign(z1.RealPart, z1.ImaginaryPart);
        z4.Assign(z1.RealPart, z1.ImaginaryPart);

        z1.CRealPwr(exp);
        z3.CIntPwr(3);
        z1.CAdd(z3);
        z4.CIntPwr(2);
        z1.CSub(z4);
        z2.CCos;
        z1.CAdd(z2);
        z1.CLn;

        inc(color);
      until (color >= max_iterations) or (abs(z1.RealPart)+abs(z1.ImaginaryPart) >= 5);
      if mode.Checked then
      setpixel(col,row,round(z1.absoluteValueSqr))
      else
      setpixel(col,row,color);
    end;
    P := P + deltaP;
  end;
  z1.Free;
  z2.Free;
  z3.Free;
  z4.Free;
  stopcalc('Ln');
end;

//Fraktal 3 z = z^exp + z + z^0.2 - c
//z0 = 0 c = koordinate
procedure TForm1.fractal3_calcClick(Sender: TObject);

var p,q : extended;
    color,row,col : integer;
    z1,z2,z3,z4 :  TJclComplex;

begin
  setup;
  startcalc;
  P := xmin;
  z1 := TJclComplex.create;
  z2 := TJclComplex.Create;
  z3 := TJclComplex.Create;
  z4 := TJclComplex.Create;
  for col :=0 to maxcol do
  begin
    Q := Ymax;
    application.ProcessMessages;
    if cancel = true then
    begin  //cancel
      z1.Free;
      z2.Free;
      stopcalc('abgebrochen');
      exit;
    end;
    for row := 0 to maxrow do
    begin
      z1.Assign(0,0);
      color := 1;
      Q := Q - deltaQ;
      z2.Assign(p,q);
      repeat
        z3.Assign(z1.RealPart,z1.ImaginaryPart );
        z4.Assign(z1.Realpart,z1.ImaginaryPart);

        z1.CRealPwr(exp);
        z1.CAdd(z3);
        z4.CRealPwr(0.2);
        z1.CAdd(z4);
        z1.CSub(z2);

        if z1.RealPart > 2 then break;
        if z1.RealPart < -2 then break;
        if z1.ImaginaryPart > 2 then break;
        if z1.ImaginaryPart < -2 then break;

        inc(color);
      until (color >= max_iterations);
      setpixel(col,row,color);
    end;
    P := P + deltaP;
  end;
  z1.Free;
  z2.Free;
  z3.Free;
  z4.Free;
  stopcalc('Fraktal 3');
end;

//*****************  Standard Settings **********************

//Beste Setings fr Fraktal 1
procedure TForm1.fractal1_2_settingsClick(Sender: TObject);

begin
  xmax_edit.Text := floattostr(1.5);
  xmin_edit.text := floattostr(-2.2);
  ymax_edit.text := floattostr(0.8);
  ymin_edit.text := floattostr(-2.8);
  julia_re_edit.Text := floattostr(0.7);
  julia_im_edit.Text := floattostr(1.0);
end;

//Beste Settings fr Mandelbrot
procedure TForm1.mandel_settingsClick(Sender: TObject);

begin
  xmax_edit.Text := floattostr(1.2);
  xmin_edit.text := floattostr(-2.0);
  ymax_edit.text := floattostr(1.2);
  ymin_edit.text := floattostr(-1.2);
  exp_edit.Text := floattostr(2);
end;

//Einstellungen fr Julia
procedure TForm1.julia_settingsClick(Sender: TObject);

var select : integer;

begin
  xmax_edit.Text := floattostr(1.5);
  xmin_edit.text := floattostr(-1.8);
  ymax_edit.text := floattostr(1.2);
  ymin_edit.text := floattostr(-1.2);
  exp_edit.Text := floattostr(2);
  randomize;
  select := random(12);
  case select of    //zufllige ein c auswhlen
    0  : begin
           julia_re_edit.Text := floattostr(0.238498);
           julia_im_edit.Text := floattostr(0.512321);
         end;
    1  : begin
           julia_re_edit.Text := floattostr(0.238498);
           julia_im_edit.Text := floattostr(0.519198);
         end;
    2  : begin
           julia_re_edit.Text := floattostr(-0.743036);
           julia_im_edit.Text := floattostr(0.113467);
         end;
    3  : begin
           julia_re_edit.Text := floattostr(-0.192175);
           julia_im_edit.Text := floattostr(0.656734);
         end;
    4  : begin
           julia_re_edit.Text := floattostr(0.108294);
           julia_im_edit.Text := floattostr(-0.670487);
         end;
    5  : begin
           julia_re_edit.Text := floattostr(-0.392488);
           julia_im_edit.Text := floattostr(-0.587966);
         end;
    6  : begin
           julia_re_edit.Text := floattostr(0.138341);
           julia_im_edit.Text := floattostr(0.649857);
         end;
    7  : begin
           julia_re_edit.Text := floattostr(0.278560);
           julia_im_edit.Text := floattostr(-0.003483);
         end;
    8  : begin
           julia_re_edit.Text := floattostr(-1.258842);
           julia_im_edit.Text := floattostr(0.065330);
         end;
    9  : begin
           julia_re_edit.Text := floattostr(-1.028482);
           julia_im_edit.Text := floattostr(-0.264756);
         end;
    10  : begin
           julia_re_edit.Text := floattostr(0.268545);
           julia_im_edit.Text := floattostr(-0.003483);
         end;
    11  : begin
           julia_re_edit.Text := floattostr(0.318623);
           julia_im_edit.Text := floattostr(0.044699);
         end;
  end;
end;

//Standard Newton Settings
procedure TForm1.newton_settingsClick(Sender: TObject);

begin
  xmax_edit.Text := floattostr(3.5);
  xmin_edit.text := floattostr(-3.5);
  ymax_edit.text := floattostr(3.5);
  ymin_edit.text := floattostr(-3.5);
end;

//Settings fr die Cosinus & co (sehr gro um die reihe zu erkennen)
procedure TForm1.c_s_ln_settingsClick(Sender: TObject);

begin
  xmax_edit.Text := floattostr(6);
  xmin_edit.text := floattostr(-6);
  ymax_edit.text := floattostr(4);
  ymin_edit.text := floattostr(-4);
  exp_edit.Text := floattostr(4);
end;

//Settings fr Fraktal 3 (das alles zu erkennen ist)
procedure TForm1.fractal3_settingsClick(Sender: TObject);

begin
  xmax_edit.Text := floattostr(1.5);
  xmin_edit.text := floattostr(-1.5);
  ymax_edit.text := floattostr(1.5);
  ymin_edit.text := floattostr(-1.5);
  exp_edit.Text := floattostr(4);
end;


//***************** Benutzerinteraktions Funktionen & Diverses *************

//Zoomout
procedure TForm1.zoom_outClick(Sender: TObject);

begin
  xmax_edit.Text := floattostr(strtofloat(xmax_edit.Text)*2);
  xmin_edit.text := floattostr(strtofloat(xmin_edit.Text)*2);
  ymax_edit.text := floattostr(strtofloat(ymax_edit.Text)*2);
  ymin_edit.text := floattostr(strtofloat(ymin_edit.Text)*2);
end;

//Zoomin
procedure TForm1.zoom_inClick(Sender: TObject);

begin
  xmax_edit.Text := floattostr(strtofloat(xmax_edit.Text)/2);
  xmin_edit.text := floattostr(strtofloat(xmin_edit.Text)/2);
  ymax_edit.text := floattostr(strtofloat(ymax_edit.Text)/2);
  ymin_edit.text := floattostr(strtofloat(ymin_edit.Text)/2);
end;

//Fenster gren nderung auf ausgabe bertragen
procedure TForm1.FormResize(Sender: TObject);

begin
  ausgabe.Picture.Bitmap.height := ausgabe.height;
  ausgabe.Picture.Bitmap.Width := ausgabe.Width;
end;

//Bild Speichern
procedure TForm1.save_buttonClick(Sender: TObject);

begin
  if save.Execute then
    ausgabe.Picture.SaveToFile(save.filename);
end;

//Bild Laden
procedure TForm1.open_buttonClick(Sender: TObject);

begin
  if open.execute then
  begin
    ausgabe.picture.loadfromfile(open.FileName);
    ausgabe.Picture.Bitmap.height := ausgabe.height;
    ausgabe.Picture.Bitmap.Width := ausgabe.Width;
  end;
end;

//Ausgabe Lschen (wei malen)
procedure TForm1.clear_outputClick(Sender: TObject);

var rect : trect;

begin
  rect.Top := 0;
  rect.Left := 0;
  rect.Bottom := ausgabe.Height;
  rect.Right := ausgabe.Width;
  ausgabe.Canvas.Fillrect(rect);
end;

//Aktuelle Koordinaten des Mauszeigers ausgeben
procedure TForm1.ausgabeMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);

begin
  label_x.caption := floattostr(deltap*x+xmin);
  label_y.caption := floattostr(-(deltaq*y-ymax));
end;

//Bei Umschaltung setezen wir die Iterations tiefe Herunter
procedure TForm1.modeClick(Sender: TObject);

begin
  if mode.checked then
    iter_edit.Text := inttostr(15)
  else
    iter_edit.Text := inttostr(250);
end;

//Initialisierungen
procedure TForm1.FormCreate(Sender: TObject);

begin
  getrect := false;
  cancel := false;
  mandel_settingsClick(sender);  //Felder initialisieren um die Fliepunktdartellung ans System anzupassen
  iter_edit.text := inttostr(250);
  julia_re_edit.text := floattostr(0.7);
  julia_im_edit.text := floattostr(1.0);
  color_edit.text := inttostr(250);
  setup;
end;

//Loslassen der Maus
procedure TForm1.ausgabeMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X_cord, Y_cord: Integer);

var x,y,x2,y2,stack : extended;

begin
 //Linksklick Loslassen fr Koordinaten bereich
 if getrect and (button = mbleft) then
 begin             //Klick loslasen  (abschlieen des ziehens)
   xmin_edit.Text := floattostr(deltap*x_cord+xmin);
   ymin_edit.Text := floattostr(-(deltaq*y_cord-ymax));

   x := strtofloat(xmax_edit.Text); //xmax
   x2 := strtofloat(xmin_edit.Text);  //xmin
   y := strtofloat(ymax_edit.Text);   //ymax
   y2 := strtofloat(ymin_edit.Text);  //ymin

   if x < x2 then
   begin
     stack := x;
     x := x2;
     x2 := stack;
   end;

   if y < y2 then
   begin
     stack := y;
     y := y2;
     y2 := stack;
   end;

   xmax_edit.Text := floattostr(x);
   xmin_edit.Text := floattostr(x2);
   ymax_edit.Text := floattostr(y);
   ymin_edit.Text := floattostr(y2);

   getrect := false;
 end
end;

//Klicken mit der Maus
procedure TForm1.ausgabeMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X_cord, Y_cord: Integer);

begin
  //Linksklick fr Koordinaten Bereich
  if Shift = [ssLeft,ssShift]  then
  begin
    //erster Klick   (aufziehen)
    xmax_edit.Text := floattostr(deltap*x_cord+xmin);
    ymax_edit.Text := floattostr(-(deltaq*y_cord-ymax));;
    getrect := true;
  end;

  //Rechtsklick fr Koordinaten von Julia
  if Shift = [ssRight]  then
  begin
    julia_re_edit.Text := floattostr(deltap*x_cord+xmin);
    julia_im_edit.Text := floattostr(-(deltaq*y_cord-ymax));
  end;
end;

//Abbrechen der aktuelen Berechung in gang setzten
procedure TForm1.cancel_buttonClick(Sender: TObject);

begin
  cancel := true;
end;

end.

