{
*****Contact*****
Bei weiteren Fragen bitte Email an mich.
If Somebody needs an english guide feel free to write me an email.
tobi@tobis-page.de
*******Info******
Fraktal Test ******light********
ein kleines Programm um etwas mit Fraktalen herum zu experimentieren
!!Achtung!! Gleitkommafehler nicht unwahrscheinlich

Unterschied der Light version:
- arbeitet Schneller da optimiert (und damit im code schwerere) Rechnung
verwendet
- bietet nur 4 Fraktale : Julia,Mandelbrot,Fraktal1&2, Newton
- keine einstellung fr exponent und Iterations Tiefe
- keine Alternative Darstellung
- weniger Sicherheitsabfragen

Autor Tobias Mark tobi@tobis-page.de
Vorgnger Version der Normale Edition
******************
}
unit fraktal_test;
{
Anleitung siehe normale Version,
fr Details bzw. verstndniss der Funktion siehe auch normale Version
Quellcode ungeordnet und wenig kommentiert
}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, math, ExtDlgs;

type
  TForm1 = class(TForm)
    ausgabe: TImage;
    Button1: TButton;
    Panel1: TPanel;
    Button2: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    Edit7: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Label5: TLabel;
    Label6: TLabel;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    Button10: TButton;
    Button11: TButton;
    Button12: TButton;
    open: TOpenPictureDialog;
    save: TSaveDialog;
    Button13: TButton;
    options: TRadioGroup;
    Label7: TLabel;
    Label8: TLabel;
    Button14: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure ausgabeMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure Button13Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button14Click(Sender: TObject);
    procedure ausgabeMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X_cord, Y_cord: Integer);
    procedure ausgabeMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X_cord, Y_cord: Integer);
  private
    deltaP,deltaQ : extended;   //Bereich den ein Pixel darstelt
    xmax,xmin,ymin,ymax : extended;   //die eingebenen Werte
    maxrow,maxcol,colormodi : integer;     //Gre des Fenster, eingabe fr Farbe
    getrect : boolean; //check ob man gerade am rechteck aufziehenist

    procedure setup; //macht die vorbereitung
    procedure setpixel(x,y,color : integer);
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

const max_iterations = 512;
      max_size=5;

procedure Tform1.setup;

begin
  xmax := strtofloat(edit1.Text);
  xmin := strtofloat(edit2.Text);
  ymax := strtofloat(edit3.Text);
  ymin := strtofloat(edit4.Text);
  colormodi := strtoint(edit7.Text);
  maxcol := ausgabe.Width;
  maxrow := ausgabe.height;
  deltaP := (xmax - xmin) / maxcol;
  deltaQ := (ymax - ymin) / maxrow;
end;

procedure Tform1.setpixel(x,y,color : integer);

begin
  case options.ItemIndex of
    0 : ausgabe.Canvas.Pixels[x,y] := color*colormodi;
    1 : ausgabe.Canvas.Pixels[x,y] := ausgabe.Canvas.Pixels[x,y] * color;
    2 : ausgabe.Canvas.Pixels[x,y] := round(ausgabe.Canvas.Pixels[x,y] / color);
    3 : ausgabe.Canvas.Pixels[x,y] := ausgabe.Canvas.Pixels[x,y] + color;
    4 : ausgabe.Canvas.Pixels[x,y] := ausgabe.Canvas.Pixels[x,y] - color;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
//Mandelbrot

var p,q,x,y : extended;
    color,row,col : integer;
    xsquare,ysquare : extended;

begin
  setup;
  P := xmin;
  for col :=0 to maxcol do
  begin
    Q := Ymax;
    application.ProcessMessages;
    for row := 0 to maxrow do
    begin
      x := 0.0;
      y := 0.0;
      color := 1;
      Q := Q - deltaQ;
      repeat
        xsquare := x*x;
        ysquare := y*Y;
        y := 2*x*y + q;
        x := xsquare - ysquare + P;
        inc(color);
      until (color >= max_iterations) or (xsquare+ysquare >= max_size);
      setpixel(col,row,color);
    end;
    P := P + deltaP;
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
//Julia

var p,q,x,y : extended;
    color,row,col : integer;
    xsquare,ysquare : extended;
    
begin
  setup;
  P := strtofloat(edit5.Text);
  Q := strtofloat(edit6.Text);
  for col :=0 to maxcol do
  begin
    application.ProcessMessages;
    for row := 0 to maxrow do
    begin
      x := xmin + col * deltaP;
      y := ymax - row * deltaQ;
      color := 1;
      repeat
        xsquare := x*x;
        ysquare := y*y;
        y := 2*x*y + q;
        x := xsquare - ysquare + P;
        inc(color);
      until (color >= max_iterations) or (xsquare+ysquare >= max_size);
      setpixel(col,row,color);
    end;
  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
//Fraktal 1

var p,q,x,y : extended;
    color,row,col : integer;
    xsquare,ysquare : extended;
    p2,q2 : extended;

begin
  setup;
  P := xmin;
  P2 := strtofloat(edit5.Text);
  Q2 := strtofloat(edit6.Text);
  for col :=0 to maxcol do
  begin
    Q := Ymax;
    application.ProcessMessages;
    for row := 0 to maxrow do
    begin
      x := 0.0;
      y := 0.0;
      color := 1;
      Q := Q - deltaQ;
      repeat
        if color mod 2 = 0 then xsquare := q2 else xsquare := x*x;
        if color mod 2 = 0 then ysquare := y*y else ysquare := p2;
        y := 2*x*y + q +q2;
        x := xsquare - ysquare + p +p2;
        inc(color);
      until (color >= max_iterations) or (xsquare+ysquare >= max_size);
      setpixel(col,row,color);
    end;
    P := P + deltaP;
  end;
end;

procedure TForm1.Button4Click(Sender: TObject);

begin
  if save.Execute then
    ausgabe.Picture.SaveToFile(save.filename);
end;

procedure TForm1.Button5Click(Sender: TObject);
//Fraktal 2

var p,q,x,y : extended;
    color,row,col : integer;
    xsquare,ysquare : extended;
    p2,q2 : extended;

begin
  setup;
  P := xmin;
  P2 := strtofloat(edit5.Text);
  Q2 := strtofloat(edit6.Text);
  for col :=0 to maxcol do
  begin
    Q := Ymax;
    application.ProcessMessages;
    for row := 0 to maxrow do
    begin
      x := 0.0;
      y := 0.0;
      color := 1;
      Q := Q - deltaQ;
      repeat
        if color mod 2 = 0 then xsquare := q2 else xsquare := x*X;
        if color mod 2 = 0 then ysquare := y*Y else ysquare := p2;
        y := 4*x*y + q +q2;
        x := xsquare - ysquare + p +p2;
        inc(color);
      until (color >= max_iterations) or (xsquare+ysquare >= max_size);
      setpixel(col,row,color);
    end;
    P := P + deltaP;
  end;
end;

procedure TForm1.Button6Click(Sender: TObject);

//Beste Setings fr Fraktal 1

begin
  edit1.Text := floattostr(1.5);
  edit2.text := floattostr(-2.2);
  edit3.text := floattostr(0.8);
  edit4.text := floattostr(-2.8);
  edit5.Text := floattostr(0.7);
  edit6.Text := floattostr(1.0);
end;

procedure TForm1.ausgabeMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  label5.caption := floattostr(deltap*x+xmin);
  label6.caption := floattostr(-(deltaq*y-ymax));
end;

procedure TForm1.Button7Click(Sender: TObject);

//Beste Settings fr Mandelbrot

begin
  edit1.Text := floattostr(1.2);
  edit2.text := floattostr(-2.0);
  edit3.text := floattostr(1.2);
  edit4.text := floattostr(-1.2);
end;

procedure TForm1.Button8Click(Sender: TObject);

//Zoomout

begin
  edit1.Text := floattostr(strtofloat(edit1.Text)*2);
  edit2.text := floattostr(strtofloat(edit2.Text)*2);
  edit3.text := floattostr(strtofloat(edit3.Text)*2);
  edit4.text := floattostr(strtofloat(edit4.Text)*2);
end;

procedure TForm1.Button9Click(Sender: TObject);

//Zoomin

begin
  edit1.Text := floattostr(strtofloat(edit1.Text)/2);
  edit2.text := floattostr(strtofloat(edit2.Text)/2);
  edit3.text := floattostr(strtofloat(edit3.Text)/2);
  edit4.text := floattostr(strtofloat(edit4.Text)/2);
end;

procedure TForm1.Button10Click(Sender: TObject);
//Einstellungen fr Julia

var select : integer;

begin
  edit1.Text := floattostr(1.2);
  edit2.text := floattostr(-2.0);
  edit3.text := floattostr(1.2);
  edit4.text := floattostr(-1.2);
  randomize;
  select := random(12);
  case select of
    0  : begin
           edit5.Text := floattostr(0.238498);
           edit6.Text := floattostr(0.512321);
         end;
    1  : begin
           edit5.Text := floattostr(0.238498);
           edit6.Text := floattostr(0.519198);
         end;
    2  : begin
           edit5.Text := floattostr(-0.743036);
           edit6.Text := floattostr(0.113467);
         end;
    3  : begin
           edit5.Text := floattostr(-0.192175);
           edit6.Text := floattostr(0.656734);
         end;
    4  : begin
           edit5.Text := floattostr(0.108294);
           edit6.Text := floattostr(-0.670487);
         end;
    5  : begin
           edit5.Text := floattostr(-0.392488);
           edit6.Text := floattostr(-0.587966);
         end;
    6  : begin
           edit5.Text := floattostr(0.138341);
           edit6.Text := floattostr(0.649857);
         end;
    7  : begin
           edit5.Text := floattostr(0.278560);
           edit6.Text := floattostr(-0.003483);
         end;
    8  : begin
           edit5.Text := floattostr(-1.258842);
           edit6.Text := floattostr(0.065330);
         end;
    9  : begin
           edit5.Text := floattostr(-1.028482);
           edit6.Text := floattostr(-0.264756);
         end;
    10  : begin
           edit5.Text := floattostr(0.268545);
           edit6.Text := floattostr(-0.003483);
         end;
    11  : begin
           edit5.Text := floattostr(0.318623);
           edit6.Text := floattostr(0.044699);
         end;
  end;

end;

procedure TForm1.Button11Click(Sender: TObject);

var color,col,row : integer;
    x,y: extended;
    nenner,x2 : extended;

begin
  setup;
  for col :=0 to maxcol do
  begin
    application.ProcessMessages;
    for row := 0 to maxrow do
    begin
      x := Xmin+col*deltap;
      y := Ymax-row*deltaq;
      color := 0;
      while (color <= max_iterations) do
      begin

        //aus c - programm:

        nenner :=  power(sqr(x)+sqr(y),3);  // = folgender Zeile
      //  nenner := (x * x + y * y) * (x * x + y * y) * (x * x + y * y);
        if nenner = 0 then nenner := 0.0000001;
      x2 := 3.0/4.0 * x + x/4.0 * (x * x - 3.0 * y * y) / nenner;
      y := 3.0/4.0 * y - y/4.0 * (3.0 *  x * x - y * y) / nenner;
      x := x2;


      if  ( (power (x - 0, 2) + power (y - 1, 2)) < 0.01 ) or
          ( (power (x + 1, 2) + power (y - 0, 2)) < 0.01 ) or
          ( (power (x - 0, 2) + power (y + 1, 2)) < 0.01 ) or
          ( (power (x - 1, 2) + power (y - 0, 2)) < 0.01    )
        then
        break;

        inc(color);
      end;
      setpixel(col,row,color);
    end;
  end;
end;

procedure TForm1.Button12Click(Sender: TObject);

begin
  edit1.Text := floattostr(3.5);
  edit2.text := floattostr(-3.5);
  edit3.text := floattostr(2.5);
  edit4.text := floattostr(-2.5);
end;

procedure TForm1.Button13Click(Sender: TObject);

begin
  if open.execute then
  begin
    ausgabe.picture.loadfromfile(open.FileName);
     ausgabe.Picture.Bitmap.height := ausgabe.height;
    ausgabe.Picture.Bitmap.Width := ausgabe.Width;
  end;
end;

procedure TForm1.FormResize(Sender: TObject);

begin
  //verbessert das verhalten beim Gre ndern
  ausgabe.Picture.Bitmap.height := ausgabe.height;
  ausgabe.Picture.Bitmap.Width := ausgabe.Width;
end;


procedure TForm1.FormCreate(Sender: TObject);

begin
  edit1.Text := floattostr(1.2);
  edit2.text := floattostr(-2.0);
  edit3.text := floattostr(1.2);
  edit4.text := floattostr(-1.2);
  edit5.text := floattostr(0.7);
  edit6.text := floattostr(1.0);
  setup;
  getrect := false;
end;

procedure TForm1.Button14Click(Sender: TObject);
//Lschen

var rect : trect;

begin
  rect.Top := 0;
  rect.Left := 0;
  rect.Bottom := ausgabe.Height;
  rect.Right := ausgabe.Width;
  ausgabe.Canvas.Fillrect(rect);
end;

//Loslassen der Maus
procedure TForm1.ausgabeMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X_cord, Y_cord: Integer);

var x,y,x2,y2,stack : extended;

begin
 //Linksklick Loslassen fr Koordinaten bereich
 if getrect and (button = mbleft) then
 begin             //Klick loslasen  (abschlieen des ziehens)
   edit2.Text := floattostr(deltap*x_cord+xmin);
   edit4.Text := floattostr(-(deltaq*y_cord-ymax));

   x := strtofloat(edit1.Text); //xmax
   x2 := strtofloat(edit2.Text);  //xmin
   y := strtofloat(edit3.Text);   //ymax
   y2 := strtofloat(edit4.Text);  //ymin

   if x < x2 then
   begin
     stack := x;
     x := x2;
     x2 := stack;
   end;

   if y < y2 then
   begin
     stack := y;
     y := y2;
     y2 := stack;
   end;

   edit1.Text := floattostr(x);
   edit2.Text := floattostr(x2);
   edit3.Text := floattostr(y);
   edit4.Text := floattostr(y2);

   getrect := false;
 end
end;

//Klicken mit der Maus
procedure TForm1.ausgabeMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X_cord, Y_cord: Integer);

begin
  //Linksklick fr Koordinaten Bereich
  if Shift = [ssLeft,ssShift] then
  begin
    //erster Klick   (aufziehen)
    edit1.Text := floattostr(deltap*x_cord+xmin);
    edit3.Text := floattostr(-(deltaq*y_cord-ymax));;
    getrect := true;
  end;

  //Rechtsklick fr Koordinaten von Julia
  if Shift = [ssRight] then
  begin
    edit5.Text := floattostr(deltap*x_cord+xmin);
    edit6.Text := floattostr(-(deltaq*y_cord-ymax));
  end;
end;

end.
