{Programm das ein Magisches Quadrat erzeugt.
Copyright 2001 by Tobias Janke (tobi@tobis-page.de)}
unit Magic;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Spin, ExtCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    SpinEdit1: TSpinEdit;
    Label1: TLabel;
    Label2: TLabel;
    SpinEdit2: TSpinEdit;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    lange : integer;
    start : integer;
    quadrat : array [1..49,1..49] of integer;
    procedure domagic;
    procedure showmagic;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure tform1.domagic;

var i,j : integer;
    posx,posy : integer;
    zahl : integer;

  function quadratgefullt : boolean;

  var i,j : integer;

  begin
    quadratgefullt := true;
    for i := 1 to lange do
      for j := 1 to lange do
      begin
        if quadrat[i,j] <> 0 then
        //nix
        else
        quadratgefullt := false;
      end;
  end;



begin
  zahl := start;
  for i := 1 to lange do
    for j := 1 to lange do
      quadrat[i,j] := 0;
  posx := 1;
  posy := (lange div 2) +1;
  quadrat[posx,posy] := zahl;
  while quadratgefullt = false do
  begin
    if posx = 1 then
    begin
      if posy = lange then
      begin
        inc(posx);
      end
      else
      begin
        inc(posy);
        posx := lange;
      end;
    end
    else
    begin
      if posy=lange then
      begin
        dec(posx);
        posy := 1;
      end
      else
      begin
        dec(posx);
        inc(posy);
        if quadrat[posx,posy] <> 0 then
        begin
          dec(posy);
          inc(posx,2);
        end
        else
        begin
          //nix
        end;
      end;
    end;
    inc(zahl);
    quadrat[posx,posy] := zahl;
  end;
end;

procedure tform1.showmagic;

var i, j : integer;
    test : integer;
    multifact : integer;
    halffact : integer;

begin
  multifact := 15+lange;
  halffact := multifact div 4;
  for i := 1 to lange do
  begin
    test := 0;
    for j := 1 to lange do
    begin
      canvas.MoveTo((j*multifact)-halffact,(i*multifact)-halffact);
      canvas.lineto(((lange+2)*multifact)-halffact,(i*multifact)-halffact);
      canvas.textout(j*multifact,i*multifact,inttostr(quadrat[i,j]));
      test := test + quadrat[i,j];
      if j = lange then
        canvas.textout((j+1)*multifact,i*multifact,inttostr(test));
    end;
  end;
  for j := 1 to lange do  //Spalten
  begin
    test := 0;
    for i := 1 to lange do
    begin
          canvas.MoveTo((j*multifact)-halffact,(i*multifact)-halffact);
    canvas.lineto((j*multifact)-halffact,((lange+2)*multifact)-halffact);

      test := test + quadrat[i,j];
      if i = lange then
        canvas.TextOut(j*multifact,(i+1)*multifact,inttostr(test));
    end;
  end;
  test := 0;
  for i := 1 to lange do  //Quer
  begin
    test := test+quadrat[i,i];
  end;
  canvas.textout((lange+1)*multifact,(lange+1)*multifact,inttostr(test));
  canvas.pen.width := 2;
  canvas.moveto((lange+1)*multifact-halffact,multifact-halffact);
  canvas.lineto((lange+1)*multifact-halffact,(lange+2)*multifact-halffact);
  canvas.moveto(multifact-halffact,(lange+1)*multifact-halffact);
  canvas.lineto((lange+2)*multifact-halffact,(lange+1)*multifact-halffact);
  canvas.pen.width := 1;
  canvas.moveto((lange+2)*multifact-halffact,multifact-halffact);
  canvas.lineto((lange+2)*multifact-halffact,(lange+2)*multifact-halffact);
  canvas.moveto(multifact-halffact,(lange+2)*multifact-halffact);
  canvas.lineto((lange+2)*multifact-halffact,(lange+2)*multifact-halffact);
end;


procedure TForm1.Button1Click(Sender: TObject);

begin
  form1.Repaint;
  if spinedit1.value mod 2 = 0 then
    spinedit1.Value := spinedit1.value -1;
  start := spinedit2.Value;
  lange := spinedit1.value;
  domagic;
  showmagic;
end;

procedure TForm1.FormCreate(Sender: TObject);

begin
  start := 1;
  lange := 3;
end;

end.
 