unit yatc_Blocks;
{YATC - Unit Global
Autor : Tobias Mark aka Colenzo (tobiasmark@gmx.de)

Erstellt die Block-Kombinationen

Version
0.4 - 18.9 : - viele neue blcke
0.3 - 15.9 : - erneuerung der Block auswahl Neue Blcke
0.2 - 26.8 : - Aufteilen der Hauptfunktion in Select und Creat, Block erzeugung unabhngig machen von Form1 (d.h. es knnte auch in ein anderes cubearray erstellt werden)
0.1 - 11.8 : - Erste version
}
{ Vorhandene Blcke : Nummer, Prozedur Name, Schwierigkeitsgrad, Bild
1 : ecke1   0,1
**
*
2 : block1   1,2
**
**
**
3 : kreuz1   2
 *
***
 *
4 : kreuz2    2
 *
****
 *
5 : doppelecke1  0,1
 **
**
6 : balken1   0
***
7 : block2     0,1
**
**
8 : doppelecke2   0,1
**
 **
9 : dreieck1 0,1
***
 *
10 : dreieck2 1,2
***
 *
 *
11 : balken2 1
****
12 : balken3 2  (wird liegd erzeugt die andern 2 stehend)
*****
13: ecke2 0,1
***
*
14: ecke3 1,2
***
*
*
15: block3 2
***
***
***
16: wtf1 2
***
* *
***
17 : horn1 1,2
***
* *
18: doppelecke3 1,2
  ***
***
19: doppelecke4 1,2
***
  ***
20: wtf2 2
*** *
* ***
}

interface

uses yatc_global,yatc_Block,sysutils,GLObjects,yatc_field;



function createblock (field : TBlockfield;mode: Rgamemode; number : integer = -1 ):TTcube;
//erzeugen eine Block im Spielfeld, number gibt optional einen speziellen block an

function newblock(field : TBlockfield;x,y : integer;b,g,r:real): TTcube;
//Setzt grundeingeschaften des neuen Blockes, Parent : erstellen unter; x,y relativ Koordnianten, b,g,r : farben

function selectblock(mode : Rgamemode): integer;
//whtl eine Block aus

implementation

uses yatc_main,yatc_script,yatc_gameoptions;

//******** Hilfs funktionen

function newblock(field : TBlockfield;x,y : integer;b,g,r:real): TTcube;
//Setzt grundeingeschaften des neuen Blockes

begin
  result := TTCube(field.content.addnewchild(TTcube));
  result.field := field;
  result.setblock(x,y);
  result.setcolor(b,g,r);
end;


  //********** Block erzeungens Teile
  function ecke1(field : TBlockField) : TTcube;
  { **
    *
  }
  var blue,green,red : real;
      i : integer;
      temp1 : TTcube;

  begin
  //  randomize;
    blue := random;        //farbe auswhlen
    green := random;
    red := random;
    i := random (field.sizeX-1);
    //Hauptwrfel
    result := newblock(field,i,field.sizeY+1,blue,green,red);
    //Rechter Nachbar
    temp1 := newblock(field,i+1,field.sizeY+1,blue,green,red);
    temp1.linked[dleft] := result;
    result.linked[dright] := temp1;
    //Unterer Nachbar
    temp1 := newblock(field,i,field.sizeY,blue,green,red);
    temp1.linked[dup] := result;
    result.linked[ddown] := temp1;
  end;


  function ecke2(field : TBlockfield) : TTcube;
  { ***
    *
  }
  var blue,green,red : real;
      i : integer;
      temp1,temp2 : TTcube;

  begin
  //  randomize;
    blue := random;        //farbe auswhlen
    green := random;
    red := random;
    i := random (field.sizeX-3)+1;
    //Hauptwrfel
    result := newblock(field,i,field.sizeY+1,blue,green,red);
    //Rechter Nachbar
    temp1 := newblock(field,i+1,field.sizeY+1,blue,green,red);
    temp1.linked[dleft] := result;
    result.linked[dright] := temp1;
    //Rechter Nachbar 2
    temp2 := newblock(field,i+2,field.sizeY+1,blue,green,red);
    temp2.linked[dleft] := temp1;
    temp1.linked[dright] := temp2;
    //Unterer Nachbar
    temp1 := newblock(field,i,field.sizeY,blue,green,red);
    temp1.linked[dup] := result;
    result.linked[ddown] := temp1;
  end;



  function ecke3(field : TBlockfield) : TTcube;
  { ***
    *
    *
  }
  var blue,green,red : real;
      i : integer;
      temp1,temp2 : TTcube;

  begin
  //  randomize;
    blue := random;        //farbe auswhlen
    green := random;
    red := random;
    i := random (field.sizeX-3)+1;
    //Hauptwrfel
    result := newblock(field,i,field.sizeY+2,blue,green,red);
    //Rechter Nachbar
    temp1 := newblock(field,i+1,field.sizeY+2,blue,green,red);
    temp1.linked[dleft] := result;
    result.linked[dright] := temp1;
    //Rechter Nachbar 2
    temp2 := newblock(field,i+2,field.sizeY+2,blue,green,red);
    temp2.linked[dleft] := temp1;
    temp1.linked[dright] := temp2;
    //Unterer Nachbar
    temp1 := newblock(field,i,field.sizeY+1,blue,green,red);
    temp1.linked[dup] := result;
    result.linked[ddown] := temp1;
    temp2 := newblock(field,i,field.sizeY,blue,green,red);
    temp2.linked[dup] := temp1;
    temp1.linked[ddown] := temp2;
  end;


  function dreieck1(field : TBlockfield) : TTcube;
  {***
    *
  }
  var blue,green,red : real;
      i : integer;
      temp1 : TTcube;

  begin
  //  randomize;
    blue := random;        //farbe auswhlen
    green := random;
    red := random;
    i := random (field.sizeX-1)+1;
    //Hauptwrfel
    result := newblock(field,i,field.sizeY+1,blue,green,red);
    //Linker Nachbar
    temp1 := newblock(field,i+1,field.sizeY+1,blue,green,red);
    temp1.linked[dleft] := result;
    result.linked[dright] := temp1;
    //Unterer Nachbar
    temp1 := newblock(field,i,field.sizeY,blue,green,red);
    temp1.linked[dup] := result;
    result.linked[ddown] := temp1;
    //Rechter Nachbar
    temp1 := newblock(field,i-1,field.sizeY+1,blue,green,red);
    temp1.linked[dright] := result;
    result.linked[dleft] := temp1;
  end;


 function horn1(field : TBlockfield) : TTcube;
  {***
   * *
  }
  var blue,green,red : real;
      i : integer;
      temp1,temp2,temp3 : TTcube;

  begin
  //  randomize;
    blue := random;        //farbe auswhlen
    green := random;
    red := random;
    i := random (field.sizeX-1)+1;
    //Hauptwrfel
    result := newblock(field,i,field.sizeY+1,blue,green,red);
    //Rechter Nachbar
    temp1 := newblock(field,i+1,field.sizeY+1,blue,green,red);
    temp1.linked[dleft] := result;
    result.linked[dright] := temp1;
    //Linker Nachbar
    temp2 := newblock(field,i-1,field.sizeY+1,blue,green,red);
    temp2.linked[dright] := result;
    result.linked[dleft] := temp2;
    //Rechter Unterer Nachbar
    temp3 := newblock(field,i+1,field.sizeY,blue,green,red);
    temp3.linked[dup] := temp1;
    temp1.linked[ddown] := temp3;
    //Linker Unterer Nachbar
    temp3 := newblock(field,i-1,field.sizeY,blue,green,red);
    temp3.linked[dup] := temp2;
    temp2.linked[ddown] := temp3;
  end;

  function dreieck2(field : TBlockfield) : TTcube;
  {***
    *
    *
  }
  var blue,green,red : real;
      i : integer;
      temp1,temp2 : TTcube;

  begin
    //randomize;
    blue := random;        //farbe auswhlen
    green := random;
    red := random;
    i := random (field.sizeX-1)+1;
    //Hauptwrfel
    result := newblock(field,i,field.sizeY+2,blue,green,red);
    //Rechter Nachbar
    temp1 := newblock(field,i+1,field.sizeY+2,blue,green,red);
    temp1.linked[dleft] := result;
    result.linked[dright] := temp1;
    //Unterer Nachbar
    temp1 := newblock(field,i,field.sizeY+1,blue,green,red);
    temp1.linked[dup] := result;
    result.linked[ddown] := temp1;
    //2ter Unterer Nachbar
    temp2 := newblock(field,i,field.sizeY,blue,green,red);
    temp2.linked[dup] := temp1;
    temp1.linked[ddown] := temp2;
    //Linker Nachbar
    temp1 := newblock(field,i-1,field.sizeY+2,blue,green,red);
    temp1.linked[dright] := result;
    result.linked[dleft] := temp1;
  end;

  function doppelecke1(field : TBlockfield) : TTcube;
  {  **
    **
  }
  var blue,green,red : real;
      i : integer;
      temp1,temp2 : TTcube;

  begin
   // randomize;
    blue := random;        //farbe auswhlen
    green := random;
    red := random;
    i := random (field.sizeX-2)+1;
    //Hauptwrfel
    result := newblock(field,i,field.sizeY+1,blue,green,red);
    //Rechter Nachbar
    temp1 := newblock(field,i+1,field.sizeY+1,blue,green,red);
    temp1.linked[dleft] := result;
    result.linked[dright] := temp1;
    //Unterer Nachbar
    temp1 := newblock(field,i,field.sizeY,blue,green,red);
    temp1.linked[dup] := result;
    result.linked[ddown] := temp1;
    //untere Linker Nachbar
    temp2 := newblock(field,i-1,field.sizeY,blue,green,red);
    temp2.linked[dright] := temp1;
    temp1.linked[dleft] := temp2;
  end;

  function doppelecke2(field : TBlockfield) : TTcube;
  {  **
      **
  }
  var blue,green,red : real;
      i : integer;
      temp1,temp2 : TTcube;

  begin
   // randomize;
    blue := random;        //farbe auswhlen
    green := random;
    red := random;
    i := random (field.sizeX-2)+1;
    //Hauptwrfel
    result := newblock(field,i,field.sizeY+1,blue,green,red);
    //Linker Nachbar
    temp1 := newblock(field,i-1,field.sizeY+1,blue,green,red);
    temp1.linked[dright] := result;
    result.linked[dleft] := temp1;
    //Unterer Nachbar
    temp1 := newblock(field,i,field.sizeY,blue,green,red);
    temp1.linked[dup] := result;
    result.linked[ddown] := temp1;
    //untere Rechter Nachbar
    temp2 := newblock(field,i+1,field.sizeY,blue,green,red);
    temp2.linked[dleft] := temp1;
    temp1.linked[dright] := temp2;
  end;

  function doppelecke3(field : TBlockfield) : TTcube;
  {  ***
   ***
  }
  var blue,green,red : real;
      i : integer;
      temp1,temp2 : TTcube;

  begin
   // randomize;
    blue := random;        //farbe auswhlen
    green := random;
    red := random;
    i := random (field.sizeX-4)+2;
    //Hauptwrfel
    result := newblock(field,i,field.sizeY+1,blue,green,red);
    //Rechter Nachbar
    temp1 := newblock(field,i+1,field.sizeY+1,blue,green,red);
    temp1.linked[dleft] := result;
    result.linked[dright] := temp1;
    //Rehcter Nachbar 2
    temp2 := newblock(field,i+2,field.sizeY+1,blue,green,red);
    temp2.linked[dleft] := temp1;
    temp1.linked[dright] := temp2;
    //Unterer Nachbar
    temp1 := newblock(field,i,field.sizeY,blue,green,red);
    temp1.linked[dup] := result;
    result.linked[ddown] := temp1;
    //untere Linker Nachbar
    temp2 := newblock(field,i-1,field.sizeY,blue,green,red);
    temp2.linked[dright] := temp1;
    temp1.linked[dleft] := temp2;
    //unterr Linker Nachbar 2
    temp1 := newblock(field,i-2,field.sizeY,blue,green,red);
    temp1.linked[dright] := temp2;
    temp2.linked[dleft] := temp1;
  end;

  function doppelecke4(field : TBlockfield) : TTcube;
  { ***
      ***
  }
  var blue,green,red : real;
      i : integer;
      temp1,temp2 : TTcube;

  begin
   // randomize;
    blue := random;        //farbe auswhlen
    green := random;
    red := random;
    i := random (field.sizeX-4)+2;
    //Hauptwrfel
    result := newblock(field,i,field.sizeY+1,blue,green,red);
    //Linker Nachbar
    temp1 := newblock(field,i-1,field.sizeY+1,blue,green,red);
    temp1.linked[dright] := result;
    result.linked[dleft] := temp1;
    //Linker Nachbar 2
    temp2 := newblock(field,i-2,field.sizeY+1,blue,green,red);
    temp2.linked[dright] := temp1;
    temp1.linked[dleft] := temp2;
    //Unterer Nachbar
    temp1 := newblock(field,i,field.sizeY,blue,green,red);
    temp1.linked[dup] := result;
    result.linked[ddown] := temp1;
    //untere Rechter Nachbar
    temp2 := newblock(field,i+1,field.sizeY,blue,green,red);
    temp2.linked[dleft] := temp1;
    temp1.linked[dright] := temp2;
    //unterer Rechter Nachbar 2
    temp1 := newblock(field,i+2,field.sizeY,blue,green,red);
    temp1.linked[dleft] := temp2;
    temp2.linked[dright] := temp1;
  end;


  function wtf2(field : TBlockfield) : TTcube;
  { *** *
    * ***
  }
  var blue,green,red : real;
      i : integer;
      temp1,temp2 : TTcube;

  begin
   // randomize;
    blue := random;        //farbe auswhlen
    green := random;
    red := random;
    i := random (field.sizeX-4)+2;
    //Hauptwrfel
    result := newblock(field,i,field.sizeY+1,blue,green,red);
    //Linker Nachbar
    temp1 := newblock(field,i-1,field.sizeY+1,blue,green,red);
    temp1.linked[dright] := result;
    result.linked[dleft] := temp1;
    //Linker Nachbar 2
    temp2 := newblock(field,i-2,field.sizeY+1,blue,green,red);
    temp2.linked[dright] := temp1;
    temp1.linked[dleft] := temp2;
    //Linker Unterer Nachbar
    temp1 := newblock(field,i-2,field.sizeY,blue,green,red);
    temp1.linked[dup] := temp2;
    temp2.linked[ddown] := temp1;
    //Unterer Nachbar
    temp1 := newblock(field,i,field.sizeY,blue,green,red);
    temp1.linked[dup] := result;
    result.linked[ddown] := temp1;
    //untere Rechter Nachbar
    temp2 := newblock(field,i+1,field.sizeY,blue,green,red);
    temp2.linked[dleft] := temp1;
    temp1.linked[dright] := temp2;
    //unterer Rechter Nachbar 2
    temp1 := newblock(field,i+2,field.sizeY,blue,green,red);
    temp1.linked[dleft] := temp2;
    temp2.linked[dright] := temp1;
    //unterer Rechter oberer Nachbar
    temp2 := newblock(field,i+2,field.sizeY+1,blue,green,red);
    temp2.linked[ddown] := temp1;
    temp1.linked[dup] := temp2;
  end;

  function block1(field : TBlockfield) : TTcube;
  { **
    **
    **
  }

  var blue,green,red : real;
      i : integer;
      temp1,temp2,temp3,temp4,temp5 : TTcube;

  begin
   // randomize;
    blue := random;        //farbe auswhlen
    green := random;
    red := random;
    i := random (field.sizeX-1) +1;
    //Hauptblock
    result := newblock(field,i,field.sizeY+1,blue,green,red);

    temp1 := newblock(field,i-1,field.sizeY+1,blue,green,red);
    temp1.linked[dright] := result;
    result.linked[dleft] := temp1;

    temp2 := newblock(field,i,field.sizeY,blue,green,red);
    temp2.linked[dup] := result;
    result.linked[ddown] := temp2;

    temp3 := newblock(field,i,field.sizeY-1,blue,green,red);
    temp3.linked[dup] := temp2;
    temp2.linked[ddown] := temp3;

    temp4 := newblock(field,i-1,field.sizeY-1,blue,green,red);
    temp4.linked[dright] := temp3;
    temp3.linked[dleft] := temp4;

    temp5 := newblock(field,i-1,field.sizeY,blue,green,red);
    temp5.linked[dup] :=  temp1;
    temp1.linked[ddown] := temp5;
    temp5.linked[dright] := temp2;
    temp2.linked[dleft] := temp5;
    temp5.linked[ddown] := temp4;
    temp4.linked[dup] := temp5;
  end;

  function block2(field : TBlockfield) : TTcube;
  { **
    **
  }

  var blue,green,red : real;
      i : integer;
      temp1,temp2,temp3 : TTcube;

  begin
   // randomize;
    blue := random;        //farbe auswhlen
    green := random;
    red := random;
    i := random (field.sizeX-1) +1;
    //Hauptblock
    result := newblock(field,i,field.sizeY+1,blue,green,red);
    //Linker Nachbar
    temp1 := newblock(field,i-1,field.sizeY+1,blue,green,red);
    temp1.linked[dright] := result;
    result.linked[dleft] := temp1;
    //unterer Nachbar
    temp2 := newblock(field,i,field.sizeY,blue,green,red);
    temp2.linked[dup] := result;
    result.linked[ddown] := temp2;
    //unterer linker Nachbar
    temp3 := newblock(field,i-1,field.sizeY,blue,green,red);
    temp3.linked[dup] := temp1;
    temp1.linked[ddown] := temp3;
    temp3.linked[dright] := temp2;
    temp2.linked[dleft] := temp3;
  end;


  function block3(field : TBlockfield) : TTcube;
  { ***
    ***
    ***
  }

  var blue,green,red : real;
      i : integer;
      temp1,temp2,temp3,temp4 : TTcube;

  begin
   // randomize;
    blue := random;        //farbe auswhlen
    green := random;
    red := random;
    i := random (field.sizeX-3) +1;
    //Hauptblock (0)
    result := newblock(field,i,field.sizeY+2,blue,green,red);
    //Linker Nachbar 1
    temp1 := newblock(field,i+1,field.sizeY+2,blue,green,red);
    temp1.linked[dleft] := result;
    result.linked[dright] := temp1;
    //Linker Nachbar 2
    temp2 := newblock(field,i+2,field.sizeY+2,blue,green,red);
    temp2.linked[dleft] := temp1;
    temp1.linked[dright] := temp2;
    //Mittler Nachbar 0
    temp3 := newblock(field,i,field.sizeY+1,blue,green,red);
    temp3.linked[dup] := result;
    result.linked[ddown] := temp3;
    //Mittlerer Nachbar 1
    temp4 := newblock(field,i+1,field.sizeY+1,blue,green,red);
    temp4.linked[dup] := temp1;
    temp4.linked[dleft] := temp3;
    temp1.linked[ddown] := temp4;
    temp3.linked[dright] := temp4;
    //Mittlerer Nachbar 2
    temp1 := newblock(field,i+2,field.sizeY+1,blue,green,red);
    temp1.linked[dup] := temp2;
    temp1.linked[dleft] := temp4;
    temp2.linked[ddown] := temp1;
    temp4.linked[dright] := temp1;
    //Unterer Nachbar 0
    temp2 := newblock(field,i,field.sizeY,blue,green,red);
    temp2.linked[dup] := temp3;
    temp3.linked[ddown] := temp2;
    //unterer Nachbar 1
    temp3 := newblock(field,i+1,field.sizeY,blue,green,red);
    temp3.linked[dup] := temp4;
    temp3.linked[dleft] := temp2;
    temp4.linked[ddown] := temp3;
    temp2.linked[dright] := temp3;
    //Unter Nachbar 2
    temp4 := newblock(field,i+2,field.sizeY,blue,green,red);
    temp4.linked[dup] := temp1;
    temp4.linked[dleft] := temp3;
    temp3.linked[dright] := temp4;
    temp1.linked[ddown] := temp4;
  end;

  function wtf1(field : TBlockfield) : TTcube;
  { ***
    * *
    ***
  }

  var blue,green,red : real;
      i : integer;
      temp1,temp2,temp3,temp4 : TTcube;

  begin
   // randomize;
    blue := random;        //farbe auswhlen
    green := random;
    red := random;
    i := random (field.sizeX-3) +1;
    //Hauptblock (0)
    result := newblock(field,i,field.sizeY+2,blue,green,red);
    //Linker Nachbar 1
    temp1 := newblock(field,i+1,field.sizeY+2,blue,green,red);
    temp1.linked[dleft] := result;
    result.linked[dright] := temp1;
    //Linker Nachbar 2
    temp2 := newblock(field,i+2,field.sizeY+2,blue,green,red);
    temp2.linked[dleft] := temp1;
    temp1.linked[dright] := temp2;
    //Mittler Nachbar 0
    temp3 := newblock(field,i,field.sizeY+1,blue,green,red);
    temp3.linked[dup] := result;
    result.linked[ddown] := temp3;
    //Mittlerer Nachbar 1 - Loch!
    //Mittlerer Nachbar 2
    temp1 := newblock(field,i+2,field.sizeY+1,blue,green,red);
    temp1.linked[dup] := temp2;
    temp2.linked[ddown] := temp1;
    //Unterer Nachbar 0
    temp2 := newblock(field,i,field.sizeY,blue,green,red);
    temp2.linked[dup] := temp3;
    temp3.linked[ddown] := temp2;
    //unterer Nachbar 1
    temp3 := newblock(field,i+1,field.sizeY,blue,green,red);
    temp3.linked[dleft] := temp2;
    temp2.linked[dright] := temp3;
    //Unter Nachbar 2
    temp4 := newblock(field,i+2,field.sizeY,blue,green,red);
    temp4.linked[dup] := temp1;
    temp4.linked[dleft] := temp3;
    temp3.linked[dright] := temp4;
    temp1.linked[ddown] := temp4;
  end;



  function kreuz1(field : TBlockfield) : TTcube;
  { *
   ***
    *
  }
  var blue,green,red : real;
     i : integer;
     temp1 : TTcube;

  begin
  //  randomize;
    blue := random;        //farbe auswhlen
    green := random;
    red := random;
    i := ((field.sizeX div 2)-1) + random(3);
    //Hauptblock
    result := newblock(field,i,field.sizeY+1,blue,green,red);
    //Linker Nachbar
    temp1 := newblock(field,i-1,field.sizeY+1,blue,green,red);
    temp1.linked[dright] := result;
    result.linked[dleft] := temp1;
    //Rechter Nachbar
    temp1 := newblock(field,i+1,field.sizeY+1,blue,green,red);
    temp1.linked[dleft] := result;
    result.linked[dright] := temp1;
    //Oberer Nachbar
    temp1 := newblock(field,i,field.sizeY+2,blue,green,red);
    temp1.linked[ddown] := result;
    result.linked[dup] := temp1;
    //Unterer Nachbar
    temp1 := newblock(field,i,field.sizeY,blue,green,red);
    temp1.linked[dup] := result;
    result.linked[ddown] := temp1;
  end;

  function balken1(field : TBlockfield) : TTcube;
  {*
   *
   *  }

  var blue,green,red : real;
     i : integer;
     temp1,temp2 : TTcube;

  begin
 //   randomize;
    blue := random;        //farbe auswhlen
    green := random;
    red := random;
    i := random(field.sizeX);
    //Hauptblock
    result := newblock(field,i,field.sizeY+2,blue,green,red);
    //1. unterer
    temp1 := newblock(field,i,field.sizeY+1,blue,green,red);
    temp1.linked[dup] := result;
    result.linked[ddown] := temp1;
    //2. unterer
    temp2 := newblock(field,i,field.sizeY,blue,green,red);
    temp2.linked[dup] := temp1;
    temp1.linked[ddown] := temp2;
  end;

  function balken2(field : TBlockfield) : TTcube;
  {*
   *
   *
   *  }

  var blue,green,red : real;
     i : integer;
     temp1,temp2 : TTcube;

  begin
 //   randomize;
    blue := random;        //farbe auswhlen
    green := random;
    red := random;
    i := random(field.sizeX);
    //Hauptblock
    result := newblock(field,i,field.sizeY+3,blue,green,red);
    //1. unterer
    temp1 := newblock(field,i,field.sizeY+2,blue,green,red);
    temp1.linked[dup] := result;
    result.linked[ddown] := temp1;
    //2. unterer
    temp2 := newblock(field,i,field.sizeY+1,blue,green,red);
    temp2.linked[dup] := temp1;
    temp1.linked[ddown] := temp2;
    //3. unterer
    temp1 := newblock(field,i,field.sizeY,blue,green,red);
    temp1.linked[dup] := temp2;
    temp2.linked[ddown] := temp1;
  end;

  function balken3(field : TBlockfield) : TTcube;
  {*****}

  var blue,green,red : real;
     i : integer;
     temp1,temp2 : TTcube;

  begin
 //   randomize;
    blue := random;        //farbe auswhlen
    green := random;
    red := random;
    if field.sizeX < 6 then i := 0
    else i := random(field.sizeX-5);
    //Hauptblock
    result := newblock(field,i,field.sizeY+1,blue,green,red);
    //1. rechter
    temp1 := newblock(field,i+1,field.sizeY+1,blue,green,red);
    temp1.linked[dleft] := result;
    result.linked[dright] := temp1;
    //2. rechter
    temp2 := newblock(field,i+2,field.sizeY+1,blue,green,red);
    temp2.linked[dleft] := temp1;
    temp1.linked[dright] := temp2;
    //3. rechter
    temp1 := newblock(field,i+3,field.sizeY+1,blue,green,red);
    temp1.linked[dleft] := temp2;
    temp2.linked[dright] := temp1;
    //4. rechter
    temp2 := newblock(field,i+4,field.sizeY+1,blue,green,red);
    temp2.linked[dleft] := temp1;
    temp1.linked[dright] := temp2;
  end;



  function kreuz2(field : TBlockfield) : TTcube;
  { *
   ****
    *
  }
  var blue,green,red : real;
     i : integer;
     temp1,temp2 : TTcube;

  begin
  //  randomize;
    blue := random;        //farbe auswhlen
    green := random;
    red := random;
    i := ((field.sizeX div 2)-1) + random(3);
    //Hauptblock
    result := newblock(field,i,field.sizeY+1,blue,green,red);
    //Linker Nachbar
    temp1 := newblock(field,i-1,field.sizeY+1,blue,green,red);
    temp1.linked[dright] := result;
    result.linked[dleft] := temp1;
    //Rechter Nachbar
    temp1 := newblock(field,i+1,field.sizeY+1,blue,green,red);
    temp1.linked[dleft] := result;
    result.linked[dright] := temp1;
    //2ter Rechter Nachbar
    temp2 := newblock(field,i+2,field.sizeY+1,blue,green,red);
    temp2.linked[dleft] := temp1;
    temp1.linked[dright] := temp2;
    //Oberer Nachbar
    temp1 := newblock(field,i,field.sizeY+2,blue,green,red);
    temp1.linked[ddown] := result;
    result.linked[dup] := temp1;
    //Unterer Nachbar
    temp1 := newblock(field,i,field.sizeY,blue,green,red);
    temp1.linked[dup] := result;
    result.linked[ddown] := temp1;
  end;


//******** Haupt Funktionen

function selectblock(mode : Rgamemode): integer;

{ 1 : ecke1   0,1
2 : block1   1,2
3 : kreuz1   2
4 : kreuz2    2
5 : doppelecke1  0,1
6 : balken1   0
7 : block2     0,1
8 : doppelecke2   0,1
//Noch nicht genau getestet
9 : dreieck1 0,1
10 : dreieck2 1,2
11 : balken2 1
12 : balken3 2
13 : ecke2 0,1
14 : ecke3 2
15 : block3 2
16 : wtf1 2
17 : horn1 1,2
18: doppelecke3 1,2
19: doppelecke4 1,2
20: wtf2 2
}


var select : integer;      //schleifen var
    test : integer;     //zufalls nummer

begin
  //randomize;
  select := -1;  //init
  test := -1;
  if select_script(test,mode) = true then   //test = -1 => schauen ob kompletter ersatz vorhanden
  begin
    select := test;  //ja ergebnis bernehmen und fertig
  end
  else          //nein normal weiter
  while select = -1 do
  begin          //Schleife bis ein Pasender Block fr Modus gewhlt ist
    test := random(optionForm.cubecount);  //Wrfeln
    case mode of   //abhnging vom modus
      desay :
      begin
       case test of     //block aussuchen (mit wahrscheinlichkeit)
         0..10 : select := 1;  //ecke1
         11..15 : select := 5; //doppelecke1
         16..25 : select := 6; //balken1
         26..32 : select := 7; //block1
         33..36 : select := 8; //doppelecke2
         37..44 : select := 9;  //dreieck1
         45..50 : select := 13; //ecke2
         else
         begin
           if select_script(test,mode) = true then  //schauen ob zusatz vorhanden & ergebniss
           begin
             select := test;     //ergebniss bernehmen
           end;
         end;
       end;
      end;
      dmedium :
      begin
        case test of
          0..4 : select := 1;  //ecke1
          5..7 : select := 2;  //block1
          8..10 : select := 5;  //doppelecke1
          11..18 : select := 7;  //block2
          19..21 : select := 8;  //doppelecke2
          22..24 : select := 9;  //dreieck1
          25..30 : select := 10; //dreieck2
          31..35 : select := 11; //balken2
          36..41 : select := 13; //ecke2
          42..43 : select := 17; //horn1
          44..47 : select := 18; //doppelecke3
          48..50 : select := 19; //doppelecke4
          else
          begin
            if select_script(test,mode) = true then  //schauen ob zusatz vorhanden & ergebniss
            begin
              select := test;     //ergebniss bernehmen
            end;
          end;
        end;
      end;
      dhard :
      begin
        case test of
          0..2 : select := 2;  //block1
          3..6 : select := 3;  //kreuz1
          7..8 : select := 4;  //kreuz2
          9..13 : select := 10; //dreieck2
          14..18 : select := 12; //balken3
          19..25 : select := 14; //ecke3
          26..29 : select := 15;  //block3
          30 : select := 16;  //wtf1
          31..36 : select := 17;  //horn1
          37..41 : select := 18; //doppelecke3
          42..48 : select := 19; //doppelecke4
          49..50 : select := 20; //wtf2
          else
          begin
            if select_script(test,mode) = true then  //schauen ob zusatz vorhanden & ergebniss
            begin
              select := test;     //ergebniss bernehmen
            end;
          end;
        end;
      end;
    end;
  end;
  result := select;
end;

function createblock(field : TBlockfield;mode: Rgamemode; number : integer = -1): TTcube;

begin
  if number = -1 then number := selectblock(mode);
    case number of  //Block nach der zugewiesen Nummer erstellen (nummer -> Block siehe Einleitung)
      1 : result := ecke1(field);
      2 : result := block1(field);
      3 : result := kreuz1(field);
      4 : result := kreuz2(field);
      5 : result := doppelecke1(field);
      6 : result := balken1(field);
      7 : result := block2(field);
      8 : result := doppelecke2(field);
      9 : result := dreieck1(field);
      10 : result := dreieck2(field);
      11 : result := balken2(field);
      12 : result := balken3(field);
      13 : result := ecke2(field);
      14 : result := ecke3(field);
      15 : result := block3(field);
      16 : result := wtf1(field);
      17 : result := horn1(field);
      18 : result :=  doppelecke3(field);
      19 : result := doppelecke4(field);
      20 : result :=  wtf2(field);
      else begin
        result := create_script(field,number);
      end;
    end;
end;

end.
